#!/bin/sh
RCS_DB_VERSION=`cat rcsDbVersion.txt`
INSTALL_LOG="rcsdbinstall.log"
TSTV_XML_DIR="/home/oracle/tstv"
TSTV_SCHEMA_FILE="ETV_EPG.xsd"
#CVS_PATH="/usr/local/tstv/TSTVWeb/rdbms"
CVS_PATH=`pwd`
#
echo `date` 
echo "Creating RCS Schema and Objects" 
#
if [ ! -d ${TSTV_XML_DIR} ]; then
	echo "Creating ${TSTV_XML_DIR} directory"
	mkdir -p ${TSTV_XML_DIR}
fi
#
echo "Copying ${CVS_PATH}/${TSTV_SCHEMA_FILE} to ${TSTV_XML_DIR} directory"
cp -fv ${CVS_PATH}/${TSTV_SCHEMA_FILE} ${TSTV_XML_DIR}/${TSTV_SCHEMA_FILE} 
#
echo "Creating RCS Tables"
sqlplus '/ as sysdba' @${CVS_PATH}/createRCS.sql ${RCS_DB_VERSION}
#
echo "Creating EPG Stored Procedure"
sqlplus 'rcs/RcS1234' @${CVS_PATH}/create_tstv.sql


echo "Creating RCSArchive DB Stored Procedure"
sqlplus '/ as sysdba' @${CVS_PATH}/createRCSArchive.sql

echo "Configuring cron job for RCSArchive"
dos2unix ${CVS_PATH}/rcs_archive_cron
dos2unix ${CVS_PATH}/rcsarchive.sh

IS_RACDB=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)

if [ "${IS_RACDB}" -eq 0 ]; then
   (crontab -l | (grep -v "rcsarchive.sh"); cat ${CVS_PATH}/rcs_archive_cron) | crontab -
   echo "Added the rcs archive job to the crontab successfully....."
elif [ "${IS_RACDB}" -eq 1 ]; then
	RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
	NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"` 
	NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`

   export ORACLE_HOME="/opt/app/oracle/product/11.2.0/db_1"
   ${ORACLE_HOME}/bin/sqlplus -S /nolog<<XYZ
    connect / as sysdba
    set serveroutput on
    declare
      DB_RCSARCHIVE_FOUND number :=0;      
    begin     
      SELECT count(*) INTO DB_RCSARCHIVE_FOUND FROM DBA_SCHEDULER_JOBS where job_name='RAC_RCSARCHIVE_JOB';
      IF (DB_RCSARCHIVE_FOUND = 0) THEN
      begin
         dbms_scheduler.drop_job( job_name => 'sys.RAC_RCSARCHIVE_JOB', force => TRUE, commit_semantics => 'ABSORB_ERRORS');
         exception when others then null;
      end;

      begin
         dbms_scheduler.drop_program( program_name => 'sys.RAC_RCSARCHIVE_prog', force => TRUE);
         exception when others then null;
      end;

      begin
         dbms_scheduler.create_program(
            program_name =>   'sys.RAC_RCSARCHIVE_prog',
            program_type =>   'executable',
            program_action => '/home/oracle/scripts/install/installrcs/rcsarchive.sh',
            enabled =>        TRUE);
         dbms_scheduler.create_job(
            job_name =>        'sys.RAC_RCSARCHIVE_JOB',
            program_name =>    'sys.RAC_RCSARCHIVE_prog',
            repeat_interval => 'FREQ=DAILY; BYHOUR=3; BYMINUTE=30');
         dbms_scheduler.enable('sys.RAC_RCSARCHIVE_job');
         dbms_scheduler.set_attribute('sys.RAC_RCSARCHIVE_JOB','logging_level',DBMS_SCHEDULER.LOGGING_FULL);
      end;
         dbms_output.put_line('Added the RCS ARCHIVE job to the database scheduler successfully.....');
      ELSE
	 dbms_output.put_line('Database RCS ARCHIVE job is already scheduled in the database.');
      END IF;

    end;
    /
XYZ
fi
exit 0