#!/bin/sh

# This script is meant for deleting the contents of tables from RCSARCHIVE schema - giving a PURGE effect
# Do not use this script if you DO NOT want PURGING

export ORACLE_SID=ttv
export ORACLE_BASE=/opt/oracle
export ORACLE_HOME=$ORACLE_BASE/product/11.2.0/db_1
$ORACLE_HOME/bin/sqlplus -s /nolog << EOM
connect / as sysdba
set serveroutput on
set echo on
set head off
spool /home/oracle/RCSArchiveDB.log
SELECT 'Script started at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;

begin
  dbms_output.put_line('Cleaning RCS Archive tables....');
  execute immediate 'truncate table rcsarchive.ALARM_ACTIVITYLOG';
  execute immediate 'truncate table rcsarchive.REC_TRIAL_USE_FIELDS';
  execute immediate 'truncate table rcsarchive.RECORDING_REC_RULES_MAP';
  execute immediate 'truncate table rcsarchive.RECORDING_LOG';
  execute immediate 'truncate table rcsarchive.RECORDABLE_RIGHTS_MAP';
  execute immediate 'truncate table rcsarchive.PLAYBACK_WINDOW_RESTRICTIONS';

  execute immediate 'delete from rcsarchive.RECORDING';
  execute immediate 'commit';

  execute immediate 'delete from rcsarchive.SCHEDULE';
  execute immediate 'commit';

  execute immediate 'delete from rcsarchive.RIGHT_RM_MAP';
  execute immediate 'commit';
  
  dbms_output.put_line('
      Archiving RCS data to RCSArchive database schema, please Wait....');
  TSTVRCSDBArchive.runarchiveonRCSDB();
end;
/
SELECT 'Script ended at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;

spool off
EOM

exit 0