#!/bin/sh

# This script is used by the cms staging script to set the RCS Archiving parameters in the DB
# See "RCS DB Archive.doc"
# This must be run as oracle user!
# Usage: setRCSArchiveParameters.sh [OLD_DATA_RETENTION_PERIOD]

if [ "$#" -ne 1 ]; then
  echo "Usage: $0 [OLD_DATA_RETENTION_PERIOD]";
  exit 1;
fi

OLD_DATA_TO_BE_ARCHIVED_VALUE="ALL"
echo "Setting OLD_DATA_TO_BE_ARCHIVED=${OLD_DATA_TO_BE_ARCHIVED_VALUE}, OLD_DATA_RETENTION_PERIOD=$1"

export ORACLE_SID=ttv
export ORACLE_BASE=/opt/oracle
export ORACLE_HOME=$ORACLE_BASE/product/11.2.0/db_1
export PATH=$PATH:$ORACLE_HOME/bin
sqlplus -s rcs/RcS1234 << EOM

MERGE INTO rcs.config_setting
  USING dual ON (UPPER(key)='OLD_DATA_RETENTION_PERIOD')
  WHEN MATCHED THEN UPDATE SET value='$1', updated_by='System', update_date=current_timestamp
  WHEN NOT MATCHED THEN INSERT (key,value,created_by,updated_by,create_date,update_date)
    VALUES ('OLD_DATA_RETENTION_PERIOD','$1','System','System',current_timestamp,current_timestamp);
MERGE INTO rcs.config_setting
  USING dual ON (UPPER(key)='OLD_DATA_TO_BE_ARCHIVED')
  WHEN MATCHED THEN UPDATE SET value='${OLD_DATA_TO_BE_ARCHIVED_VALUE}', updated_by='System', update_date=current_timestamp
  WHEN NOT MATCHED THEN INSERT (key,value,created_by,updated_by,create_date,update_date)
    VALUES ('OLD_DATA_TO_BE_ARCHIVED','${OLD_DATA_TO_BE_ARCHIVED_VALUE}','System','System',current_timestamp,current_timestamp);
/
EOM

