/*

  @version $Id: CreateRMDB.sql,v 1.2 2008/09/18 18:36:43 akharul Exp $

*/
set echo on

DEF RM_VERSION=&1;

CREATE OR REPLACE PACKAGE SYS.CREATERMDB AS
    /*
        Created By: Daniel Weiner 5/20/2008
                Combined createRM, covertRM, and installRM
                scripts into one package.  installRM is public
                and createRM and convertRM are private.
    */

	PROCEDURE INSTALL_RM;
  vsql varchar2(32000);
  vschema varchar2(100) := 'RM';
END;
/
CREATE OR REPLACE PACKAGE BODY SYS.CREATERMDB AS

FUNCTION IS_COLUMN_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from DBA_TAB_COLS where owner=UPPER(IN_OWNER) AND TABLE_NAME=UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;
 /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  exception
    when others then
          verrmsg := errmsg ||' '||sqlerrm;
          select cast(verrmsg as varchar2(4000)) 
          into verrmsg
          from dual;
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  END CREATEOBJECT;
  
/* Procedure: SetDbCreateFileDest. Sets the default directory for Oracle datafiles so the path
              need not be given when creating tablespaces. */
  PROCEDURE SETDBCREATEFILEDEST(vpath varchar2) IS
  BEGIN
    execute immediate 'alter system set db_create_file_dest='''||vpath||''' scope=both';
  END SETDBCREATEFILEDEST;

	 PROCEDURE CREATERM IS
	 /*  
			Created By: Daniel Weiner S
      DATE:   		5/20/2008
	    COMMENTS:	Create RM tables, sequences,triggers,views,etc
      Updated: 11/03/2008 - Murtaza Habib - Created Modular functions to create objects and better error handling
	 */

		wk_database_path	NVARCHAR2(100);
		wk_instancename	NVARCHAR2(30);
		wk_message		NVARCHAR2(500);
		
	BEGIN
		wk_message := '';
      
    -- Drop the install_table
    vsql:='Drop table sys.install_table';
		CREATEOBJECT(vsql,'DROP INSTALL_TABLE','Y');

    -- Create Install_table
    vsql:='CREATE TABLE sys.install_table (msgdate date default sysdate, install_message varchar2(4000))';
		CREATEOBJECT(vsql,'CREATE SYS.INSTALL_TABLE');

		/*
		--------------------------------------------------------------------
		CREATE USER AND TABLESPACES
		--------------------------------------------------------------------
		*/
		
		SELECT INSTANCE_NAME INTO wk_instancename FROM V$INSTANCE;

    SELECT value INTO vsql FROM v$parameter WHERE name='db_create_file_dest';
    
    IF vsql IS NULL THEN
      -- Set db_create_file_dest to default directory
      select substr(file_name,1,instr(file_name,'/',-1) -1)
      INTO vsql
      from dba_data_files
      WHERE tablespace_name = 'SYSTEM';
      
      --SETDBCREATEFILEDEST(vsql);
		END IF;
    
    -- Drop WFS_data tablespace
    vsql :='drop tablespace tstv_rm  including contents and datafiles';
  	CREATEOBJECT(vsql,'DROP TABLESPACE tstv_rm ','Y');
      
      -- Creating RM_data tablespace
    vsql :='create tablespace tstv_rm  datafile size 500M AUTOEXTEND ON NEXT 250M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL AUTOALLOCATE SEGMENT SPACE MANAGEMENT AUTO';
		CREATEOBJECT(vsql,'CREATE TABLESPACE tstv_rm ');

		-- Set Default temp tablespace to temp
    vsql :=  'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE temp';
    CREATEOBJECT(vsql,'Default Tablespace temp','Y');      
      
		--DROP RM USER
    vsql :=  'drop user '||vschema||' cascade';
    CREATEOBJECT(vsql,'DROP USER '||vschema,'Y');
      
		--CREATE RM USER
    vsql :=  'create user '||vschema||' identified by Rm1234 default tablespace tstv_rm';
    CREATEOBJECT(vsql,'CREATE USER '||vschema);
      
		--Grant privs to RM user
    vsql :=  'grant resource, connect, create session to '||vschema;
    CREATEOBJECT(vsql,'Unable to grant  resource, connect and create session to the '||vschema||' user.');
                    
		/*
		--------------------------------------------------------------------
		CREATING TABLES
		--------------------------------------------------------------------
		*/

		-- CREATE TABLE RM
    vsql := 'CREATE TABLE '||vschema||'.RM ( 
					RM_ID                          	NUMBER(19,0) NOT NULL,
					NAME                        	NVARCHAR2(64) NOT NULL,
					IP_ADDRESS                  	NVARCHAR2(16) NOT NULL,
					PORT                        	NUMBER(10,0) NOT NULL,
					BFS_IP_ADDRESS              	NVARCHAR2(16) NOT NULL,
					BFS_PORT                    	NUMBER(5,0) NOT NULL,
					ADI_EXPORT_ATTEMPTS    			NUMBER(2,0) NULL,
					ADI_EXPORT_ATTEMPT_INTERVAL    	NUMBER(10,0) NULL,						
					SCHEDULE_READER_INTERVAL    	NUMBER(10,0) NULL,
					RCS_URL                     	NVARCHAR2(128) NOT NULL,
					PACKAGER_URL                    NVARCHAR2(250) NULL,
					RM_TYPE                     	NVARCHAR2(50) NOT NULL,
					KEEP_RUNNING	             	NUMBER(1,0) NOT NULL,						
					STATUS              	 		NUMBER(10,0) NULL,
					OPERATIONAL_STATE              	NUMBER(10,0) NULL,
					PRE_PROVISIONING_INTERVAL		NUMBER(5,0) NOT NULL,
					STATUS_UPDATE	        		TIMESTAMP(0) WITH TIME ZONE NULL,
					CREATE_DATE                 	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE                 	TIMESTAMP(0) WITH TIME ZONE NOT NULL, 
					STATUS_PUSH_LAST_ID				NUMBER(19,0) NULL,
					MAINTENANCE_WINDOW_START_DATE	TIMESTAMP(0) WITH TIME ZONE NULL,
					MAINTENANCE_WINDOW_DURATION		NUMBER(10,0) NULL,
                      CONSTRAINT PK_RM PRIMARY KEY (RM_ID),
                      CONSTRAINT UQ_RM_IP_PORT UNIQUE (IP_ADDRESS, PORT))';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.RM ');

	-- CREATE TABLE ADI_XML_SITE
	vsql := 'CREATE TABLE '||vschema||'.ADI_XML_SITE ( 
	     ADI_XML_SITE_ID NUMBER (19,0)  NOT NULL , 
	     NAME NVARCHAR2 (100)  NOT NULL , 
	     URL NVARCHAR2 (1000)  NOT NULL , 
	     CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL, 
	     UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
	     RM_ID NUMBER(19,0) NOT NULL ,
	     	CONSTRAINT ADI_XML_SITE_PK PRIMARY KEY ( ADI_XML_SITE_ID ),
	     	CONSTRAINT XML_SITE_NAME_UNIQUE UNIQUE (RM_ID,NAME),
	     	CONSTRAINT FK_ADIXMLSITE_RM FOREIGN KEY(RM_ID) REFERENCES '||vschema||'.RM(RM_ID) ON DELETE SET NULL)';
	CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ADI_XML_SITE ');

	-- CREATE TABLE POOL
	vsql := 'CREATE TABLE '||vschema||'.POOL ( 
				POOL_ID   	NUMBER(19,0) NOT NULL,
				RM_ID		NUMBER(19,0) NOT NULL,
				NAME       NVARCHAR2(64) NULL,
				KEEP_RUNNING	NUMBER(1,0) NOT NULL,
				CREATE_DATE     TIMESTAMP(0) WITH TIME ZONE NOT NULL,
				UPDATE_DATE     TIMESTAMP(0) WITH TIME ZONE NOT NULL, 						
              CONSTRAINT PK_POOL PRIMARY KEY (POOL_ID,RM_ID),
              CONSTRAINT FK_POOL_RM FOREIGN KEY(RM_ID) REFERENCES '||vschema||'.RM(RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.POOL ');
	
		-- CREATE TABLE RTC
    vsql :=  'CREATE TABLE '||vschema||'.RTC (
					RTC_ID              NUMBER(19,0) NOT NULL,
					NAME       			NVARCHAR2(64) NULL,
					IP_ADDRESS        	NVARCHAR2(16) NOT NULL,
					PORT              	NUMBER(10,0) NOT NULL,
					SERVICE_NAME 		NVARCHAR2(64) NOT NULL,
					CAPACITY          	NUMBER(3,0) NULL,
					KEEP_RUNNING		NUMBER(1,0) NOT NULL,						
					POOL_ID           	NUMBER(19,0) NOT NULL,
					RM_ID				NUMBER(19,0) NOT NULL,
					IS_REACHABLE		NUMBER(2,0) NOT NULL,
					OPERATIONAL_STATE   NUMBER(10,0) NULL,
					LAST_STATUS_UPDATE	TIMESTAMP(0) WITH TIME ZONE NULL,
					CREATE_DATE       	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE       	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					USER_ID				NVARCHAR2(256),
				    PASSWORD			NVARCHAR2(1024),
				    DOMAIN				NVARCHAR2(256),
				    HOST_IP_ADDRESS     NVARCHAR2(16),
                      CONSTRAINT PK_RTC PRIMARY KEY (RTC_ID),
                      CONSTRAINT UQ_RTC_IP UNIQUE (IP_ADDRESS, PORT, SERVICE_NAME),
                      CONSTRAINT FK_RTC_POOL FOREIGN KEY(POOL_ID,RM_ID) REFERENCES '||vschema||'.POOL(POOL_ID,RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.RTC ');

		-- CREATE TABLE CHANNEL_POOL_MAPPING
		vsql := 'CREATE TABLE '||vschema||'.CHANNEL_POOL_MAPPING ( 
					CHANNEL_ID              NVARCHAR2(100) NOT NULL,
					NAME       NVARCHAR2(64) NULL,
					POOL_ID             	NUMBER(19,0) NOT NULL,
					RM_ID			NUMBER(19,0) NOT NULL,
					MULTICAST_IP_ADDRESS	NVARCHAR2(25) NOT NULL,
					MULTICAST_PORT      	NUMBER(10,0) NOT NULL,
					SD_MIN_BITRATE 	NUMBER(20,0) NOT NULL,
					SD_MAX_BITRATE 	NUMBER(20,0) NOT NULL,
					HD_MIN_BITRATE 	NUMBER(20,0) NOT NULL,
					HD_MAX_BITRATE 	NUMBER(20,0) NOT NULL,
					CALL_SIGN		NVARCHAR2(100),
					LOCATION		NVARCHAR2(32),
					MEDIATYPE       NVARCHAR2(200),
					MANIFESTNAME    NVARCHAR2(200),
					PUBLISHPOINT    NVARCHAR2(200),
					CREATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,					
                CONSTRAINT PK_CHANNEL_POOL_MAPPING PRIMARY KEY (CHANNEL_ID, POOL_ID,RM_ID),
                CONSTRAINT FK_CHANNEL_POOL_MAPPING_POOL FOREIGN KEY(POOL_ID,RM_ID) REFERENCES '||vschema||'.POOL(POOL_ID,RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CHANNEL_POOL_MAPPING ');

		-- CREATE TABLE RECORDING
    vsql :=  'CREATE TABLE '||vschema||'.RECORDING ( 
					-- HEADER INFORMATION
					ASSET_ID               	NVARCHAR2(20) NOT NULL,
					POOL_ID                	NUMBER(19,0) NOT NULL,
					RM_ID                  	NUMBER(19,0) NOT NULL,
					RECORDING_MODE			NVARCHAR2(10) NOT NULL,
					CHANNEL_ID             	NVARCHAR2(100) NOT NULL,
					RECORD_HD_CONTENT		NVARCHAR2(1) NULL,
					RECORD_START_TIME      	TIMESTAMP(0) WITH TIME ZONE NULL,
					RECORD_END_TIME        	TIMESTAMP(0) WITH TIME ZONE NULL,
					RECORD_PRIORITY        	NUMBER(3,0) NOT NULL,
					REDUNDANCY_COUNT       	NUMBER(3,0) NOT NULL,
                    REDUNDANCY_SUCCESS      NUMBER(3,0) DEFAULT 0,
                    REDUNDANCY_FAILURES     NUMBER(3,0) DEFAULT 0,
					PROVIDER_ID            	NVARCHAR2(20) NOT NULL,
					SCHEDULE_ID       		NUMBER(19,0) DEFAULT 0 NOT NULL,

					-- TRIAL USE INFORMATION
					PROGRAM_NAME			NVARCHAR2(64) NOT NULL,
					REPEAT					NVARCHAR2(1) NULL,
					CONTRACT_ID				NVARCHAR2(16) NOT NULL,
					RECORDING_REGION		NVARCHAR2(256) NOT NULL,
					PLAYBACK_WINDOWS		NVARCHAR2(256) NULL,
					MAX_COPIES				NUMBER(10,0) NULL,
					DELETE_TIME				TIMESTAMP(0) WITH TIME ZONE NULL,
					REF_COUNT				NUMBER(3,0) NULL,
					CATALOG_ENTRY			NVARCHAR2(1) NULL,
					PURGE_TIME				TIMESTAMP(0) WITH TIME ZONE NULL,
					
					-- CABLE LAB INFORMATION
					RUN_TIME               	NVARCHAR2(16) NULL,
					RATING                 	NVARCHAR2(2000) NULL,
					TYPE                   	NVARCHAR2(32) NULL,
					CATEGORY               	NVARCHAR2(2000) NULL,
					ACTOR                  	NVARCHAR2(2000) NULL,
					YEAR                   	NUMBER(4,0) NULL,
					EPISODE_TITLE          	NVARCHAR2(255) NULL,
					EPISODE_NUMBER         	NVARCHAR2(16) NULL,
					TITLE                  	NVARCHAR2(255) NULL,
					TITLE_BRIEF            	NVARCHAR2(255) NULL,
					SUMMARY_SHORT          	NVARCHAR2(256) NULL,
					SUMMARY_MEDIUM         	NVARCHAR2(1024) NULL,
					SUMMARY_LONG          	NVARCHAR2(2000) NULL,
					ADVISORIES             	NVARCHAR2(1024) NULL,
					DISPLAY_RUN_TIME       	NVARCHAR2(16) NULL,
					BILLING_ID             	NVARCHAR2(16) NULL,
					LICENSING_WINDOW 		NVARCHAR2(2000) NOT NULL,
					SERIES_ID              	NVARCHAR2(100) NULL,
					LANGUAGE               	NVARCHAR2(25) NULL,
					AUDIO_TYPE             	NVARCHAR2(25) NULL,
					BITRATE                	FLOAT NULL,
					CONTENT_FILESIZE       	NUMBER(19,0) NULL,
					CONTENT_CHECKSUM       	NVARCHAR2(32) NULL,
					VERSION_MAJOR          	NUMBER(10,0) NULL,
					VERSION_MINOR          	NUMBER(10,0) NULL,
					PREVIEW_PERIOD         	NUMBER(10,0) NULL,
					CLOSED_CAPTIONING  		NVARCHAR2(1),
					PROVIDER_QA_CONTACT    	NVARCHAR2(128) NULL,
					VIEWING_WINDOW_START   	TIMESTAMP(0) WITH TIME ZONE NULL,
					VIEWING_WINDOW_DURATION	TIMESTAMP(0) WITH TIME ZONE NULL,
					TITLE_ASSET_ID         	NVARCHAR2(20) NULL,
					MOVIE_ASSET_ID         	NVARCHAR2(20) NULL,
					PROVIDER               	NVARCHAR2(128) NULL,
					CONTENT_URL            	NVARCHAR2(1024) NULL,
					PRODUCT_TYPE			NVARCHAR2(32) NOT NULL,
					APP_TYPE				NVARCHAR2(32) NOT NULL,
					
					POSTER_ASSET_ID			NVARCHAR2(20) NULL,
					POSTER_IMAGE_NAME		NVARCHAR2(256) NULL,
					POSTER_DESCRIPTION		NVARCHAR2(1024) NULL,
										
					-- ADI SITES INFORMATION
					ADI_XML_SITE_SUCCESS		NUMBER(1,0) NOT NULL,
	
					-- OTHER INFORMATION
					COMMAND                	NUMBER(4,0) NOT NULL,
					STATUS                 	NUMBER(4,0) NULL,
					EXTEND_STOP_APPLIED     NUMBER(1,0) NOT NULL,
					LAST_STATUS_UPDATE     	TIMESTAMP(0) WITH TIME ZONE NULL,
					CREATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
                  CONSTRAINT PK_RECORDING PRIMARY KEY (ASSET_ID, POOL_ID,RM_ID),
                  CONSTRAINT FK_RECORDING_POOL FOREIGN KEY(POOL_ID,RM_ID) REFERENCES '||vschema||'.POOL(POOL_ID,RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.Recording');

    vsql := 'CREATE INDEX '||vschema||'.IDX_RCRDNG_ID_CMND_STUS ON '||vschema||'.RECORDING(RM_ID, COMMAND, STATUS)';
    CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_RCRDNG_ID_CMND_STUS');

		-- CREATE TABLE RECORDING_LOGS
    vsql :=  'CREATE TABLE '||vschema||'.RECORDING_LOGS (
    				ID				NUMBER(19, 0) NOT NULL,
					ASSET_ID      	NVARCHAR2(20) NOT NULL,
					POOL_ID       	NUMBER(19,0) NOT NULL,
					RM_ID         	NUMBER(19,0) NOT NULL,
					STATUS_CODE   	NUMBER(4,0) NOT NULL,
					STATUS_MESSAGE	NVARCHAR2(1024) NOT NULL,
					SUB_COMPONENT_STATUS NUMBER(19,0) NULL,
					SUB_COMPONENT_TYPE NVARCHAR2(256) NULL,
					SUB_COMPONENT_ID NVARCHAR2(256) NULL,
					RAISE_TRAP 		NUMBER(1,0) DEFAULT 0,
    				RAISE_EVENT 	NUMBER(1,0) DEFAULT 0,
    				WARNING 		NUMBER(1,0) DEFAULT 0,
					CREATE_DATE   	TIMESTAMP(0) WITH TIME ZONE NOT NULL, 
                      CONSTRAINT PK_RECORDING_LOGS PRIMARY KEY (ID))';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.RECORDING_LOGS ');	   

		-- CREATE TABLE RTC
    vsql :=  'CREATE TABLE '||vschema||'.RTC_RECORDING (
					RM_ID             	NUMBER(19,0) NOT NULL,
					ASSET_ID          	NVARCHAR2(20) NOT NULL,
					POOL_ID             NUMBER(19,0) NOT NULL,
					RTC_ID            	NUMBER(19,0) NOT NULL,
					RTC_IP_ADDRESS    	NVARCHAR2(16) NOT NULL,
					RTC_PORT          	NUMBER(10,0) NOT NULL,
					RTC_SERVICE_NAME NVARCHAR2(64) NOT NULL,
					STATUS            	NUMBER(10,0) NULL,
                    PROVISION_TRY_STATUS NUMBER(10,0) NULL,
					EXTEND_STOP_TRY_STATUS NUMBER(10,0) NULL,
					LAST_STATUS_UPDATE	TIMESTAMP(0) WITH TIME ZONE NULL,
					CONTENT_URL       	NVARCHAR2(1024) NULL,
					CONTENT_FILESIZE  	NUMBER(19,0) NULL,
					CONTENT_CHECKSUM  	NVARCHAR2(32) NULL,
					SELECTED          	NUMBER(1,0) NULL, 
					CREATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE            	TIMESTAMP(0) WITH TIME ZONE NOT NULL,						
                      CONSTRAINT PK_RTC_RECORDING PRIMARY KEY (RM_ID, ASSET_ID, POOL_ID, RTC_ID),
                      CONSTRAINT FK_RTC_RECORDING_RECORDING FOREIGN KEY(ASSET_ID, POOL_ID,RM_ID) REFERENCES '||vschema||'.RECORDING(ASSET_ID, POOL_ID,RM_ID) ON DELETE SET NULL,
                      CONSTRAINT FK_RTC_RECORDING_RTC FOREIGN KEY(RTC_ID) REFERENCES '||vschema||'.RTC(RTC_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.RTC_RECORDING ');	   

    vsql := 'CREATE INDEX '||vschema||'.IDX_RTC_REC_AST_POL_RM ON '||vschema||'.RTC_RECORDING(RM_ID, POOL_ID, ASSET_ID)';
    CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_RTC_REC_AST_POL_RM');

		-- CREATE TABLE RTI_PROVISION
    vsql :=  'CREATE TABLE '||vschema||'.RTI_PROVISION (
					ASSET_ID          	NVARCHAR2(20) NOT NULL,
					POOL_ID             NUMBER(19,0) NOT NULL,
					RM_ID             	NUMBER(19,0) NOT NULL,
					PROVISIONING_ASSET_ID	NVARCHAR2(20) NOT NULL,				
					NAME    	NVARCHAR2(64) NOT NULL,
					PROVIDER_ID          	NVARCHAR2(20) NOT NULL,
					FTP_URL NVARCHAR2(1024) NOT NULL,
					STATUS            	NUMBER(10,0) NULL,
					LAST_STATUS_UPDATE	TIMESTAMP(6) NULL,
					CREATE_DATE            	TIMESTAMP(6) NOT NULL,
					UPDATE_DATE            	TIMESTAMP(6) NOT NULL,						
                      CONSTRAINT PK_RTI_PROVISION PRIMARY KEY (RM_ID, ASSET_ID, POOL_ID, FTP_URL),
                      CONSTRAINT FK_RTI_PROVISION_RECORDING FOREIGN KEY(ASSET_ID, POOL_ID,RM_ID) REFERENCES '||vschema||'.RECORDING(ASSET_ID, POOL_ID,RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.RTI_PROVISION ');	   

    vsql := 'CREATE INDEX '||vschema||'.IDX_RTI_RROV_AST_POL_RM ON '||vschema||'.RTI_PROVISION(RM_ID, POOL_ID, ASSET_ID)';
    CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_RTI_RROV_AST_POL_RM');


		-- CREATE TABLE SYSTEM_SETTING
    vsql := 'CREATE TABLE '||vschema||'.SYSTEM_SETTING ( 
					KEY        		NVARCHAR2(255) NOT NULL,
					VALUE      		NVARCHAR2(32) NULL,
					CREATE_DATE		TIMESTAMP(0) WITH TIME ZONE NOT NULL,
					UPDATE_DATE		TIMESTAMP(0) WITH TIME ZONE NOT NULL,
                    CONSTRAINT PK_SYSTEM_SETTING PRIMARY KEY (KEY))';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SYSTEM_SETTING ');
    
		
		-- CREATE TABLE TRIAL_USE_FIELDS
    vsql := 'CREATE TABLE '||vschema||'.TRIAL_USE_FIELDS (
					ID                		NUMBER(19,0) NOT NULL,
					ASSET_ID               	NVARCHAR2(20) NOT NULL,
					POOL_ID                	NUMBER(19,0) NOT NULL,
					RM_ID                  	NUMBER(19,0) NOT NULL,
					ASSET_TYPE        		NUMBER(2) NOT NULL,
					NAME      				NVARCHAR2(2000) NOT NULL,
					VALUE					NVARCHAR2(2000),
                    CONSTRAINT PK_TRIAL_USE_FIELDS PRIMARY KEY (ID),
                    CONSTRAINT FK_TRIAL_USE_FIELDS_RECORDING FOREIGN KEY (ASSET_ID, POOL_ID,RM_ID) REFERENCES '||vschema||'.RECORDING(ASSET_ID, POOL_ID,RM_ID) ON DELETE SET NULL)';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRIAL_USE_FIELDS ');

    vsql := 'CREATE INDEX '||vschema||'.IDX_TUF_AST_POL_RM ON '||vschema||'.TRIAL_USE_FIELDS(RM_ID, POOL_ID, ASSET_ID)';
    CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_TUF_AST_POL_RM');

		-- CREATE TABLE STILL_IMAGE_REPOSITORY
    vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_REPOSITORY (
					IMAGE_NAME				NVARCHAR2(256) NOT NULL,
					FILE_NAME				NVARCHAR2(256) NOT NULL,
					ASPECT_RATIO			NVARCHAR2(32),
					FILE_SIZE				NUMBER(19,0) NOT NULL,
					CHECK_SUM				NVARCHAR2(32) NOT NULL,
					IMAGE					BLOB NOT NULL,
	     			CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL, 
	     			UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
                    CONSTRAINT PK_STILL_IMAGE_REPOSITORY PRIMARY KEY (IMAGE_NAME))
                    LOB(IMAGE) STORE AS SECUREFILE';
    CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STILL_IMAGE_REPOSITORY ');

	--------------------------------------------------------------------
		-- CREATING SEQUENCES
	
	vsql := 'CREATE SEQUENCE '||vschema||'.RECORDING_LOG_SEQ MINVALUE 1 
				MAXVALUE 9223372036854775806
				START WITH 1
    			INCREMENT BY 1
    			CYCLE';
	CREATEOBJECT(vsql,'Unable to create sequence '||vschema||'.RECORDING_LOG_SEQ ');

	vsql := 'CREATE SEQUENCE '||vschema||'.TRIAL_USE_FIELDS_SEQ MINVALUE 1 
				MAXVALUE 9223372036854775806
				START WITH 1
    			INCREMENT BY 1
    			CYCLE';
	CREATEOBJECT(vsql,'Unable to create sequence '||vschema||'.TRIAL_USE_FIELDS_SEQ ');
	--------------------------------------------------------------------
		
		
		-- SET DBVERSION
    vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTING (KEY,VALUE,CREATE_DATE,UPDATE_DATE) VALUES(''DBVERSION'',''&RM_VERSION'',sysdate ,sysdate )';
    CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.SYSTEM_SETTING ');
		
		<<bypass_install>>
		
		COMMIT;
		
		IF wk_message = 'ERROR'
		THEN
		  RAISE_APPLICATION_ERROR(-20001, 'The Recording Manager version &RM_VERSION install failed.  View the install_table for details');
		ELSE
		      EXECUTE IMMEDIATE 'INSERT INTO install_table values (sysdate,''Installation of version &RM_VERSION completed SUCCESSFULLY'')';
		END IF;
		
		COMMIT;
	END CREATERM;
	
	PROCEDURE CONVERTRM IS
		/*  
			Created By: Daniel Weiner 
			DATE:   		5/20/2008
		*/
		wk_prod_release		NVARCHAR2(100);
		wk_release		NVARCHAR2(100);
		v_SQLBlock		NVARCHAR2(300);
		wk_message		NVARCHAR2(100);
		wk_database_path	NVARCHAR2(100);
		wk_count		number;

	BEGIN

    -- Drop the install_table
    vsql:='Drop table sys.install_table';
		CREATEOBJECT(vsql,'DROP INSTALL_TABLE','Y');

    -- Create Install_table
    vsql:='CREATE TABLE sys.install_table (msgdate date default sysdate, install_message varchar2(4000))';
		CREATEOBJECT(vsql,'CREATE SYS.INSTALL_TABLE');

	execute immediate 'SELECT VALUE FROM '||vschema||'.SYSTEM_SETTING WHERE KEY = ''DBVERSION''' into wk_release;
	IF wk_release < '3.1.0000'
	THEN	
			-- CREATE TABLE TRIAL_USE_FIELDS
	    vsql := 'CREATE TABLE '||vschema||'.TRIAL_USE_FIELDS (
						ID                		NUMBER(19,0) NOT NULL,
						ASSET_ID               	NVARCHAR2(20) NOT NULL,
						POOL_ID                	NUMBER(19,0) NOT NULL,
						RM_ID                  	NUMBER(19,0) NOT NULL,
						ASSET_TYPE        		NUMBER(2) NOT NULL,
						NAME      				NVARCHAR2(2000) NOT NULL,
						VALUE					NVARCHAR2(2000),
	                    CONSTRAINT PK_TRIAL_USE_FIELDS PRIMARY KEY (ID),
	                    CONSTRAINT FK_TRIAL_USE_FIELDS_RECORDING FOREIGN KEY (ASSET_ID, POOL_ID,RM_ID) REFERENCES '||vschema||'.RECORDING(ASSET_ID, POOL_ID,RM_ID) ON DELETE SET NULL)';
	    	CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRIAL_USE_FIELDS ');
			
		vsql := 'CREATE SEQUENCE '||vschema||'.TRIAL_USE_FIELDS_SEQ MINVALUE 1 
					MAXVALUE 9223372036854775806
					START WITH 1
	    			INCREMENT BY 1
	    			CYCLE';
			CREATEOBJECT(vsql,'Unable to create sequence '||vschema||'.TRIAL_USE_FIELDS_SEQ ');
			
		vsql := 'ALTER TABLE '||vschema||'.RTC ADD (
						USER_ID NVARCHAR2(256),
						PASSWORD NVARCHAR2(1024),
						DOMAIN NVARCHAR2(256))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RTC ');
	END IF;
	IF wk_release < '3.1.0001'
	THEN	
		vsql := 'ALTER TABLE '||vschema||'.RECORDING MODIFY (
						ACTOR NVARCHAR2(2000))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');
	END IF;
	IF wk_release < '3.1.0002'
	THEN	
		vsql := 'ALTER TABLE '||vschema||'.RTC_RECORDING MODIFY (
						CONTENT_URL NVARCHAR2(1024))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RTC_RECORDING ');
	END IF;	
	IF wk_release < '3.1.0003'
	THEN	
		vsql := 'ALTER TABLE '||vschema||'.RTC ADD (
						HOST_IP_ADDRESS     NVARCHAR2(16))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RTC ');
	END IF;	
	IF wk_release < '3.2.0102'
	THEN
		vsql := 'CREATE INDEX '||vschema||'.IDX_RTC_REC_AST_POL_RM ON '||vschema||'.RTC_RECORDING(RM_ID, POOL_ID, ASSET_ID)';
    		CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_RTC_REC_AST_POL_RM');

    	vsql := 'CREATE INDEX '||vschema||'.IDX_RTI_RROV_AST_POL_RM ON '||vschema||'.RTI_PROVISION(RM_ID, POOL_ID, ASSET_ID)';
    		CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_RTI_RROV_AST_POL_RM');
		
		vsql := 'CREATE INDEX '||vschema||'.IDX_TUF_AST_POL_RM ON '||vschema||'.TRIAL_USE_FIELDS(RM_ID, POOL_ID, ASSET_ID)';
    		CREATEOBJECT(vsql,'Unable to create index '||vschema||'.IDX_TUF_AST_POL_RM');
	END IF;
	IF wk_release < '3.3.000.0'
	THEN
		vsql := 'ALTER TABLE '||vschema||'.RECORDING ADD (
						LICENSING_WINDOW     NVARCHAR2(2000) DEFAULT '' '' NOT NULL)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');

		vsql := 'UPDATE '||vschema||'.RECORDING SET LICENSING_WINDOW = RECORDING_MODE || ''::'' || to_char(LICENSING_WINDOW_START,''yyyy-mm-dd hh24:mi:ss tzr'') ||''##'' || to_char(LICENSING_WINDOW_END,''yyyy-mm-dd hh24:mi:ss tzr'')';		
		CREATEOBJECT(vsql,'Unable to update '||vschema||'.RECORDING');

		vsql := 'ALTER TABLE '||vschema||'.RECORDING DROP (
						LICENSING_WINDOW_START,LICENSING_WINDOW_END)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');
		
		vsql := 'ALTER TABLE '||vschema||'.RM ADD (
						PRE_PROVISIONING_INTERVAL	NUMBER(5,0) DEFAULT 120 NOT NULL,
						MAINTENANCE_WINDOW_START_DATE	TIMESTAMP(0) WITH TIME ZONE NULL,
						MAINTENANCE_WINDOW_DURATION		NUMBER(10,0) NULL)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RM ');

		vsql := 'ALTER TABLE '||vschema||'.RECORDING ADD (
						SCHEDULE_ID	NUMBER(19,0) DEFAULT 0 NOT NULL)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');		
	END IF;
	
	IF wk_release < '3.3.000.3'
	THEN
		vsql := 'ALTER TABLE '||vschema||'.CHANNEL_POOL_MAPPING ADD (
						LOCATION     NVARCHAR2(32),
						CALL_SIGN	NVARCHAR2(100))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.CHANNEL_POOL_MAPPING ');
	END IF;
	
	IF wk_release < '4.0.000.0'
	THEN
	    vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_REPOSITORY (
						IMAGE_NAME				NVARCHAR2(256) NOT NULL,
						FILE_NAME				NVARCHAR2(256) NOT NULL,
						ASPECT_RATIO			NVARCHAR2(32),
						FILE_SIZE				NUMBER(19,0) NOT NULL,
						CHECK_SUM				NVARCHAR2(32) NOT NULL,
						IMAGE					BLOB NOT NULL,
	     				CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL, 
	     				UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
	                    CONSTRAINT PK_STILL_IMAGE_REPOSITORY PRIMARY KEY (IMAGE_NAME))
	                    LOB(IMAGE) STORE AS SECUREFILE';
	    	CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STILL_IMAGE_REPOSITORY ');
		
		vsql := 'ALTER TABLE '||vschema||'.RECORDING ADD (
					POSTER_ASSET_ID			NVARCHAR2(20) NULL,
					POSTER_IMAGE_NAME		NVARCHAR2(256) NULL,
					POSTER_DESCRIPTION		NVARCHAR2(1024) NULL)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');

      	-- Set Category field wider for Multiple Category feature
      	vsql := 'ALTER TABLE '||vschema||'.RECORDING MODIFY (CATEGORY NVARCHAR2(2000))';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING re: Category size ');
		
		vsql := 'ALTER TABLE '||vschema||'.RECORDING ADD (
					REDUNDANCY_SUCCESS      NUMBER(3,0) DEFAULT 0,
                    REDUNDANCY_FAILURES     NUMBER(3,0) DEFAULT 0,
					EXTEND_STOP_APPLIED     NUMBER(1,0) DEFAULT 0 NOT NULL)';
				CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING ');
				
		vsql := 'ALTER TABLE '||vschema||'.RTC_RECORDING ADD (
					PROVISION_TRY_STATUS NUMBER(10,0) NULL,
                    EXTEND_STOP_TRY_STATUS NUMBER(10,0) NULL)';
				CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RTC_RECORDING ');

		vsql := 'ALTER TABLE '||vschema||'.RECORDING_LOGS ADD (
					SUB_COMPONENT_STATUS NUMBER(19,0) NULL,
					SUB_COMPONENT_TYPE NVARCHAR2(256)NULL,
					SUB_COMPONENT_ID NVARCHAR2(256) NULL,
					RAISE_TRAP 		NUMBER(1,0) DEFAULT 0,
    				RAISE_EVENT 	NUMBER(1,0) DEFAULT 0,
    				WARNING			NUMBER(1,0) DEFAULT 0)';
			CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.RECORDING_LOGS ');

	END IF; -- End of 4.0.000.0


	IF wk_release < '4.0.000.2'
	THEN
	
	 vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=216 WHERE STATUS=202'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=221 WHERE STATUS=203'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=223 WHERE STATUS=205'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=214 WHERE STATUS=206'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=225 WHERE STATUS=505'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS=223 WHERE STATUS=501'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING table');

	 vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=216 WHERE STATUS_CODE=202'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

     vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=221 WHERE STATUS_CODE=203'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

     vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=223 WHERE STATUS_CODE=205'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

     vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=214 WHERE STATUS_CODE=206'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

     vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=225 WHERE STATUS_CODE=505'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

     vsql := 'UPDATE '||vschema||'.RECORDING_LOGS SET STATUS_CODE=223 WHERE STATUS_CODE=501'; 
     CREATEOBJECT(vsql,'Unable to UPDATE RECORDING_LOGS table');

    END IF; -- End of 4.0.000.2
	
	IF wk_release < '6.0.000.0'
	THEN
		IF is_column_exists( vschema, 'CHANNEL_POOL_MAPPING', 'MEDIATYPE' ) = false THEN
			vsql := 'alter table '||vschema||'.CHANNEL_POOL_MAPPING add MEDIATYPE NVARCHAR2(200)';
			CREATEOBJECT( vsql,'alter TABLE channel_pool_mapping add mediatype' );
		END IF;
		IF is_column_exists( vschema, 'CHANNEL_POOL_MAPPING', 'MANIFESTNAME' ) = false THEN
			vsql := 'alter table '||vschema||'.CHANNEL_POOL_MAPPING add MANIFESTNAME NVARCHAR2(200)';
			CREATEOBJECT( vsql, 'alter TABLE channel_pool_mapping add manifestname' );
		END IF;
		IF is_column_exists( vschema, 'CHANNEL_POOL_MAPPING', 'PUBLISHPOINT' ) = false THEN
			vsql := 'alter table '||vschema||'.CHANNEL_POOL_MAPPING add PUBLISHPOINT NVARCHAR2(200)';
			CREATEOBJECT( vsql, 'alter TABLE channel_pool_mapping add publishpoint' );
		END IF;
	END IF; -- End of 6.0.000.0
    
     	
		-- SET RMVERSION - Version will be updated by installer during installer creation time 
		vsql := 'UPDATE '||vschema||'.SYSTEM_SETTING SET VALUE = ''&RM_VERSION'' WHERE KEY = ''DBVERSION''';
		CREATEOBJECT(vsql,'Unable to update '||vschema||'.SYSTEM_SETTING');
							
		IF wk_message = 'ERROR'
		THEN
			COMMIT;
			RAISE_APPLICATION_ERROR(-20001, 'The Recording Manager version &RM_VERSION upgrade failed.  View the install_table for details');
		ELSE
		   EXECUTE IMMEDIATE 'INSERT INTO install_table values (sysdate,''Upgrade to &RM_VERSION completed SUCCESSFULLY'')';
		END IF;

		COMMIT;
	END CONVERTRM;
	
	PROCEDURE INSTALL_RM IS
	/*  
	  Created By: Chris Scherlacher 7/30/2007
	  Added procedure to the RMDB package from the previons sql script.
	*/
	
	  wk_count	number;
	
	BEGIN
	
	  SELECT COUNT(*) 
	  INTO wk_count
	  FROM all_tables
	  WHERE owner = vschema AND
	        table_name = 'SYSTEM_SETTING';
	
	  IF wk_count = 0 THEN
	
	     CREATERM();
	
	  ELSE
	
	     CONVERTRM();
	
	  END IF;
	
	END INSTALL_RM;

END;
/

begin
	creatermdb.install_rm();
end;
/

exit
