#!/bin/sh
## @version $Id: installRM.sh,v 1.8 2012/05/15 19:52:17 cbentz Exp $
##
## create the database
##
#INSTALL_DIR="/usr/local/tstv/RMScheduler/rdbms"
INSTALL_DIR=`pwd`
DB_INSTALL_LOG=rmdbinstall.log
RM_VERSION=`cat rmVersion.txt`

if [ -z "$ORACLE_SID" ];
then
	echo "Exporting environment variable ORACLE_SID=ttv"
	export ORACLE_SID=ttv
fi

sqlplus '/ as sysdba' @${INSTALL_DIR}/CreateRMDB.sql ${RM_VERSION} | tee ${INSTALL_DIR}/${DB_INSTALL_LOG}

echo "*********************************************************"
if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${DB_INSTALL_LOG}"
then
	echo "RM DB Install script probably failed! Check ${INSTALL_DIR}/${DB_INSTALL_LOG} file for any errors"
	exit 1
else
	echo "DB INSTALL SCRIPT SUCCEEDED!"
fi
echo "*********************************************************"

exit 0

