#************************************************************************************#
#         Script : cmsexport.sh                                                      #
#         Purpose: To create all cms schemas data dump.                              #
#         Usage  : sh cmsexport.sh [<SID>]                                           #
#         Date   : 09/02/2012                                                        #
#************************************************************************************#
#!/bin/sh
ORACLE_SID=$1
BACKUP_DIR=`pwd`
DUMP_FILE="cms_exp_data%u.dmp"
LOG_FILE="cms_exp_data.log"
#ORA_HOME="/opt/app/oracle/product/11.2.0/db_1"
ORA_HOME="/opt/oracle/product/11.2.0/db_1"
if [ `whoami` !=  "oracle" ]; then
   echo -e "\nYou can run this script as oracle user only, Please try again as oracle user....!\n"
   exit 1
fi
if [ "$ORACLE_SID" = "" ]; then
  echo ""
  echo "Database SID defaulted to ttv."
  #ORACLE_SID="ttv"
  ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
fi
mkdir -p ${BACKUP_DIR}
#rm -f "${BACKUP_DIR}/rcs_data.dmp" >> /dev/null
rm -f "${BACKUP_DIR}/${LOG_FILE}" >> /dev/null
CMS_SCHEMA_COUNT=$(sqlplus -s /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username in ('WFS','WPTB','WFSDW','RCS','RCSARCHIVE');
  exit
SQL1
)
if [ "${CMS_SCHEMA_COUNT}" -gt 0 ]; then
  echo "******************************************************************************"
  echo ""
  echo "Running the script, please wait...!"
$ORA_HOME/bin/sqlplus -s /nolog<<SQEOF
   connect / as sysdba
   set verify off
   set feedback on
   set serveroutput on
   begin
     for I in (select 'ALTER INDEX '||TABLE_OWNER||'.'|| INDEX_NAME||' REBUILD' rb_indexes
                 from DBA_INDEXES
                where TABLE_OWNER in ('WFS','WPTB','WFSDW','RCS','RCSARCHIVE')
                  and INDEX_TYPE='NORMAL'
                  and table_name not like '%\$%' 
                  and table_name not like 'SYS%'
                  and STATUS = 'UNUSABLE'
              )
     loop
       execute immediate(i.rb_indexes);
     end loop;
   exception
     when OTHERS then
       dbms_output.put_line('*** Error'||substr(sqlerrm,1,200));
   end;
   /
   BEGIN
     FOR XML_SCHEMAS IN (SELECT schema_id FROM DBA_XML_SCHEMAS WHERE SCHEMA_URL='ECMFSpec.xsd' and hidden='YES') 
     LOOP
       DBMS_OUTPUT.PUT_LINE('deleting schema id '||XML_SCHEMAS.SCHEMA_ID||'.');
       DBMS_XMLSCHEMA.PURGESCHEMA(xml_schemas.schema_id);
     END LOOP;
   EXCEPTION
     WHEN OTHERS THEN null;
   END;
   /
   BEGIN
      execute immediate 'DROP DIRECTORY CMSBACKUPDIR';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   CREATE DIRECTORY CMSBACKUPDIR AS '${BACKUP_DIR}';
   exit
SQEOF
expdp \"\/\ as\ sysdba\" directory=cmsbackupdir dumpfile=${DUMP_FILE} logfile=${LOG_FILE}  FILESIZE=5G exclude=statistics compression=ALL schemas=WFS,WPTB,RCS,RCSARCHIVE EXCLUDE=TABLE:\"IN \(\'DB_CLUSTER_INSTANCES\'\)\"
$ORACLE_HOME/bin/sqlplus -s /nolog<<EOF  
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback off
   BEGIN
      execute immediate 'DROP DIRECTORY CMSBACKUPDIR';
   END;
   /
EOF
else
  echo ""
  echo "CMS DB schemas not found, contact DBA for further assistance...."
  echo ""
  exit 1
fi

exit
