#************************************************************************************#
#         Script : cmsimport.sh                                                      #
#         Purpose: To load datga dump into CMS Schema.                               #
#         Usage  : sh cmsimport.sh [<SID>]                                           #
#         Date   : 10/10/2012                                                        #
#************************************************************************************#
#!/bin/sh
ORACLE_SID=$1
BACKUP_DIR=`pwd`
DUMP_FILE="cms_exp_data%u.dmp"
LOG_FILE="cms_imp_data.log"
ORA_HOME="/opt/app/oracle/product/11.2.0/db_1"
rm -f ${BACKUP_DIR}/${LOG_FILE} >> /dev/null
if [ `whoami` !=  "oracle" ]; then
   echo -e "\nYou can run this script as oracle user only, Please try again as oracle user....!\n"
   exit 1
fi
if [ ! -f "${BACKUP_DIR}/cms_exp_data01.dmp" ]; then
  echo -e "\nCMS data dump file not exists, please verify and try again ...!\n"
  exit 1
fi
if [ "$ORACLE_SID" = "" ]; then
  #echo -e "\nDatabase SID defaulted."
  ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
fi
CMS_SCHEMA_COUNT=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username in ('WFS','WFSDW','WPTB','RCS','RCSARCHIVE');
  exit
SQL1
)
if [ "${CMS_SCHEMA_COUNT}" -gt 0 ]; then

DB_CONS=$(sqlplus -S /nolog<<EOFSQL
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM v\$session WHERE username in ('WFS','WPTB','RCS','RCSARCHIVE') and status not in ('KILLED');
  exit
EOFSQL
)

if [ "$DB_CONS" -gt 0 ]; then
  echo -e "\nPlease close CMS, RCS service on the app server and try again....!\n"
  exit 1
fi
  echo "******************************************************************************"
  echo -e "            CMS Data load started at $(date)"
  echo "******************************************************************************"
  echo -e "\nPlease wait...!\n"
$ORACLE_HOME/bin/sqlplus -s /nolog<<SQEOF
   connect / as sysdba
   set verify off
   set feedback off
   set serveroutput on
   BEGIN
      execute immediate 'DROP USER WFS CASCADE';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   BEGIN
      execute immediate 'DROP USER WPTB CASCADE';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   BEGIN
      execute immediate 'DROP USER RCS CASCADE';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   BEGIN
      execute immediate 'DROP USER RCSARCHIVE CASCADE';
   EXCEPTION
      when others then
        dbms_output.put_line('RCSARCHIVE user not exists.');
   END;
   /
   BEGIN
      execute immediate 'DROP DIRECTORY CMSBACKUPDIR';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   CREATE DIRECTORY CMSBACKUPDIR AS '${BACKUP_DIR}';
   exit
SQEOF
CHECK_SCHEMAS_COUNT=$(sqlplus -S /nolog<<PQR
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username in ('WFS','WPTB','RCS','RCSARCHIVE');
  exit
PQR
)
if [ "${CHECK_SCHEMAS_COUNT}" -gt 0 ]; then
  echo -e "\nDue to some database connections, old CMS database schemas can not be dropped."
  echo -e "Plese disconnect all the database connetctions and try again.\n"
  exit 1
fi
impdp \"\/\ as\ sysdba\" directory=cmsbackupdir dumpfile=${DUMP_FILE} logfile=${LOG_FILE} ACCESS_METHOD=EXTERNAL_TABLE statistics=none schemas=WFS,WPTB,RCS,RCSARCHIVE  
if  grep -q "successfully completed" "${BACKUP_DIR}/${LOG_FILE}" 
then
echo -e "CMS Database users permissions grant script is running, please wait....!\n"
$ORACLE_HOME/bin/sqlplus -s /nolog<<EOF  
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback off
   spool "${BACKUP_DIR}/${LOG_FILE}" append
   BEGIN
      execute immediate 'DROP DIRECTORY CMSBACKUPDIR';
   END;
   /
   alter system set deferred_segment_creation=false;
   alter system set nls_length_semantics=char;
   alter session set nls_length_semantics=char;
   grant create view,select any dictionary to wfs;
   --alter system set cursor_sharing=EXACT; 
   grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCS;
   grant all on dbms_xmlschema to RCS;
   grant all on dbms_errlog to RCS;
   grant create database link to RCS;
   grant all on directory tstvxmldir to public,rcs;
   grant create database link to RCS;
   grant execute on tstvdb to RCS;
   spool off
EOF
RCSARC_COUNT=$(sqlplus -S /nolog<<PQR
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username='RCSARCHIVE';
  exit
PQR
)
if [ "${RCSARC_COUNT}" -eq 1 ]; then
  $ORACLE_HOME/bin/sqlplus -s /nolog<<XYZ
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback off
   spool "${BACKUP_DIR}/${LOG_FILE}" append
   grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCSARCHIVE;
   grant all on dbms_xmlschema to RCSARCHIVE;
   grant all on dbms_errlog to RCSARCHIVE;
   grant create database link to RCSARCHIVE;
   grant references on rcs.schedule to rcsarchive;
   grant references on rcs.program to rcsarchive;
   grant references on rcs.station to rcsarchive;
   grant references on rcs.rtc_pool to rcsarchive;
   grant references on rcs.headend to rcsarchive;
   grant references on rcs.rm to rcsarchive;
   grant references on rcs.right to rcsarchive;
   grant references on rcs.ENTITY_MAPPING to rcsarchive;
   grant references on rcs.RECORDING_RULES to rcsarchive;
   grant references on rcs.ERROR_CODE to rcsarchive;
   spool off
XYZ

fi
RACDB_CNT=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)
if [ "${RACDB_CNT}" -eq 1 ]; then
  $ORACLE_HOME/bin/sqlplus -s /nolog<<XZY
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback off
   spool "${BACKUP_DIR}/${LOG_FILE}" append
   BEGIN
      execute immediate 'DROP FUNCTION wfs.fn_db_instance_status';
   EXCEPTION
      WHEN others THEN null;
   END;
   /

   BEGIN
      execute immediate 'DROP TABLE wfs.db_cluster_instances';
   EXCEPTION
      WHEN others THEN null;
   END;
   /

   CREATE OR REPLACE VIEW wfs.db_cluster_instances AS   
    SELECT SUBSTR(v.target_name,length(v.target_name)) AS INST_ID,
           SUBSTR(v.target_name,instr(v.target_name,'_')+1) AS DB_INSTANCE_NAME,
           v.host_name as HOST_NAME,
           case when (i.inst_id>0) then 'Active' else 'Down' end AS DATABASE_ROLE,
           IC.INET_ADDRESS AS IP_ADDRESS,
           case when (i.inst_id is null) then 3 else 1 end AS DB_INST_STATUS
      FROM MGMT\$HW_NIC ic,
           mgmt\$ha_info_all v,
           GV\$INSTANCE i
     WHERE ic.host_name   = v.host_name
       AND v.host_name    = i.host_name (+) 
       AND v.target_type  = 'oracle_database'
       AND ic.name        = 'eth0' 
       AND i.status   (+) = 'OPEN'
     ORDER BY inst_id;
   spool off
XZY
    fi
    echo "******************************************************************************"
    echo -e "            CMS Data load ended at $(date)."
    echo "******************************************************************************"
  else
    echo "Data import probably failed! Check ${BACKUP_DIR}/${LOG_FILE} file for any errors"
    echo "*********************************************************"
    exit 1
  fi
else
  echo ""
  echo "CMS DB schemas are not found, contact DBA for further assistance...."
  echo ""
  exit 1
fi

exit
