#!/bin/sh

#INSTALL_DIR=/home/oracle/scripts/db_upgrade
INSTALL_DIR=`pwd`
DB_UPGRADE_LOG="upgrade.log"
POST_UPGRADE_LOG="post_upgrade.log"

#check this script should run only for oracle user.
if [ `whoami` !=  "oracle" ]; then
  echo "**************************************************************"
  echo "You can run this script as an oracle user only,"
  echo "Please try again as an oracle user....!"
  echo "**************************************************************"
  exit 1
fi

  echo " "
  echo "***********************************************************************"
  echo " Database post upgrade started at $(date) "
  echo "***********************************************************************"
  echo " "

  source ${INSTALL_DIR}/instscr/post_upgrade.sh ${INSTALL_DIR} ${POST_UPGRADE_LOG} 2>&1 | tee -a ${INSTALL_DIR}\/${DB_UPGRADE_LOG}
  if [ ! -f ${INSTALL_DIR}/${POST_UPGRADE_LOG} ] 
  then
     echo "**************************************************************************************"
     echo " DB Upgrade script probably failed!  ${INSTALL_DIR}/${POST_UPGRADE_LOG} file is not exists..!"
     echo "**************************************************************************************"
     exit 1       	
  else
     if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${POST_UPGRADE_LOG}"  
     then
        echo "**************************************************************************************"
        echo " DB Upgrade script probably failed! Check ${INSTALL_DIR}/${POST_UPGRADE_LOG} file for any errors"
        echo "**************************************************************************************"
        exit 1
     else
 
        CNT_INVALID_COMPS=`/opt/oracle/product/11.2.0/db_1/bin/sqlplus -S /nolog<<SQL1
           connect / as sysdba
           set heading off
           set feedback off
           select trim(count(status)) from dba_registry where status != 'VALID';
           exit;
SQL1`

        if [ ${CNT_INVALID_COMPS}="0" ];
        then
           echo "*******************************************************************************"
           echo " Database post upgrade successfully completed at $(date) "
           echo "*******************************************************************************"
           echo ""
           echo ""
           echo ""
           echo ""
        else
           echo "***********************************************************************"
           echo " DB post upgrade script failed! Check log file for any errors"
           echo "***********************************************************************"
           exit 1
        fi
     fi
   fi

exit 0
