#!/bin/sh

#INSTALL_DIR=/home/oracle/scripts/db_upgrade
INSTALL_DIR=`pwd`
DB_UPGRADE_LOG="upgrade.log"
BINARY_INSTALL_LOG="binary_output.log"

# checks before starting the upgrade
source ${INSTALL_DIR}/instscr/checks_before_upgrade.sh
if [ $? -gt 0 ]; then
     exit 1
fi  

  echo " "
  echo "***********************************************************************"
  echo "**** Database upgrade started at $(date) "
  echo " "
  echo "  THIS SCRIPT WILL TAKE SOME TIME TO COMPLETE, PLEASE WAIT......!"
  echo "  UNTIL THE SCRIPT COMPLETES AND RETURNS TO THE COMMAND PROMPT."
  echo "***********************************************************************"
  echo " "
  echo " "
  mkdir -p /opt/oracle/oradata/TTV/datafile/TTV/datafile
  # Restore the DB from older server to new server
  source ${INSTALL_DIR}/instscr/restore_ttv.sh ${INSTALL_DIR} 2>&1 | tee ${INSTALL_DIR}\/${DB_UPGRADE_LOG}
  if [ $? -gt 0 ]; then
     echo "There is an error, exiting the upgrade script on Primary DB .....!"
     exit 1
  else
     if [ $(cat ${INSTALL_DIR}/${DB_UPGRADE_LOG} | grep "Database altered" |wc -l ) != 1 ];
     then
        echo "***********************************************************************"
        echo "Installtion not successful, check the log file for any errors.....!"
        echo "***********************************************************************"
        exit 1
     fi
  fi

  source ${INSTALL_DIR}/db_post_upgrade.sh 2>&1 | tee -a ${INSTALL_DIR}\/${DB_UPGRADE_LOG}
  if [ $? -gt 0 ]; then
     echo "There is an error during post upgrade! Please check ${INSTALL_DIR}\/${DB_UPGRADE_LOG}"
     exit 1
  fi

  echo " "
  echo "***********************************************************************"
  #echo "**** Database restore and upgrade completed at $(date) "
  echo "**** Database restore completed successfully at $(date) "
  echo "***********************************************************************"
  echo " "
exit 0
