#!/bin/sh

# check this script should run only for oracle user.
if [ `whoami` !=  "oracle" ]; then
  echo "**************************************************************"
  echo " You can run this script as an oracle user only,"
  echo " Please try again as an oracle user....!"
  echo "**************************************************************"
  exit 1
fi

# check if old server backups are copied to new server
DTSTAMP=`ls -dt /opt/oracle/backup/ttv/full/backup* | awk -F / '{print }' | cut -d'_' -f2 | head -1`
if [ ! -d "/opt/oracle/backup/ttv/full/backup_${DTSTAMP}" ];
then
  echo "**************************************************************"
  echo " Backups from older server have not been copied to this server"
  echo " No backups found in /opt/oracle/backup/ttv/full folder"
  echo "**************************************************************"
  exit 1
fi

# check the oracle version before start the installation.
if [ -f /opt/oraInventory/ContentsXML/inventory.xml ]; 
then
  ORA_VERSION=$(egrep "SAVED_WITH" /opt/oraInventory/ContentsXML/inventory.xml | tr -d '[A-Z,\<,/>,_, ]') 
else
   if [ -f /opt/oraInventory/ContentsXML/inventory.xml ]; 
   then
     ORA_VERSION=$(egrep "SAVED_WITH" /opt/oraInventory/ContentsXML/inventory.xml | tr -d '[A-Z,\<,/>,_, ]') 
   else
       echo "*****************************************************************"
       echo " Oracle installation not found, please check and try again .....!"
       echo "*****************************************************************"
       exit 1
   fi
fi

if [ ""${ORA_VERSION} != "11.2.0.3.0" ];
then
  echo "*****************************************************************"
  echo " Oracle software 11.2.0.3.0 is not installed on this server.!"
  echo "*****************************************************************"
  exit 1
fi

#check the db ttv is up and running or not
check_db_stat=`ps -ef|grep ttv |grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
if [ $oracle_num -eq 0 ];
then
  echo "*****************************************************************"
  echo " Database is not running, try running the script after starting "
  echo " the database please....!"
  echo "*****************************************************************"
  exit 1
fi
