#!/bin/sh

#START DB UPGRADE

INSTALL_DIR=$1
POST_UPGRADE_LOG=$2
HOSTNM=`hostname`
SID=( ttv )

lsnrctl start

for ORA_SID in "${SID[@]}"
do
  export ORACLE_SID=${ORA_SID}

  #step 2) startup the database for UPGRADE.
	
    sqlplus -S /nolog<<EOF_SQL1
      connect / as sysdba
      shutdown immediate
      startup upgrade 
      @${ORACLE_HOME}/rdbms/admin/catupgrd.sql
EOF_SQL1

    echo "End of catupgrd.sql............"

    #step 3) startup the database and run the following scripts to create the new packages for upgraded version.  

    sqlplus -S /nolog<<EOF_SQL2
      connect / as sysdba
      startup
      @${ORACLE_HOME}/rdbms/admin/utlu112s.sql
      spool ${INSTALL_DIR}/${POST_UPGRADE_LOG}
      @${ORACLE_HOME}/rdbms/admin/catuppst.sql
      @${ORACLE_HOME}/rdbms/admin/utlrp.sql
      spool off
EOF_SQL2

  echo "End of catuppst.sql............"

done

echo ""
