#!/bin/sh

INSTALL_DIR=$1
HOSTNM=`hostname`

echo " DB Upgrade started at $(date) "

#Get latest date stamp of backup
DTSTAMP=`ls -ldt /opt/oracle/backup/ttv/full/backup* | awk -F / '{print }' | cut -d'_' -f2 | head -1`
mv /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/spfile_ttv_${DTSTAMP}.ora /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/old_spfile_ttv_${DTSTAMP}.ora
if [ -f "/opt/oracle/product/11.2.0/db_1/dbs/spfilettv.ora" ]
then
  cp -f /opt/oracle/product/11.2.0/db_1/dbs/spfilettv.ora /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/spfile_ttv_${DTSTAMP}.ora
else
DB_STATUS=$(sqlplus -S /nolog<<PQR
  connect / as sysdba
  set pages 0
  set feedback off
  select trim(STATUS) from v\$instance;
  exit
PQR
)
if [ "${DB_STATUS}" = "OPEN" ]; 
then
echo "copying spfile from db to backup folder..."
sqlplus -S /nolog << SQLEF
  connect / as sysdba
  set pages 0
  set feedback off
  create spfile='/opt/oracle/backup/ttv/full/backup_${DTSTAMP}/spfile_ttv_${DTSTAMP}.ora' from memory;
  exit
SQLEF
else
  echo -e "Data base is not open\n"
  exit 1
fi
fi
#step 1) check the database version.
  DB_VERSION_CNT=`/opt/oracle/product/11.2.0/db_1/bin/sqlplus -S /nolog<<SQL1
           connect / as sysdba
           set heading off
           set feedback off
           select instr(banner,'Enterprise Edition',1,1) from v\\$version where rownum<2;
           exit;
SQL1`
  if [ $DB_VERSION_CNT -gt 0 ];
  then
     DB_VERSION="ee"
  else
     DB_VERSION="se"
  fi

#step 2) shutdown the database.
  dbshut $ORACLE_HOME

#step 3) Drop ttv db
echo "    "
echo "DROPPING EXISTING ${ORACLE_SID} DB INSTANCE..."
echo "    "
sqlplus -S /nolog << SQLEOF1
connect / as sysdba
startup mount restrict
drop database ;
SQLEOF1
if [ ! -f "/opt/oracle/product/11.2.0/db_1/dbs/spfilettv.ora" ]
then
  cp -f /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/spfile_ttv_${DTSTAMP}.ora /opt/oracle/product/11.2.0/db_1/dbs/spfilettv.ora
fi
ln -s /opt/oracle/product/11.2.0/db_1 /opt/oracle/product/11.2.0/dbhome_1
mkdir -p /opt/oracle/oradata/TTV/datafile/TTV/datafile
mkdir -p /opt/oracle/oradata/TTV/datafile/TTV1/datafile
mkdir -p /opt/oracle/oradata/TTV/datafile/TTV2/datafile
mkdir -p /opt/oracle/oradata/TTV1/datafile/TTV1/datafile
mkdir -p /opt/oracle/oradata/TTV2/datafile/TTV2/datafile
# Copying initttv.ora file to ORacle home dbs folder for rman 
cp /home/oracle/scripts/db_restore/initttv.ora /opt/oracle/product/11.2.0/db_1/dbs/initttv.ora

#Get latest date stamp of backup
DTSTAMP=`ls -ldt /opt/oracle/backup/ttv/full/backup* | awk -F / '{print }' | cut -d'_' -f2 | head -1`

rman target=/ << RMANEOF1
startup nomount
restore controlfile from '/opt/oracle/backup/ttv/full/backup_${DTSTAMP}/controlfile_${DTSTAMP}.ctl';
alter database mount;
restore database;
recover database;
exit;
RMANEOF1

#step 4) Open the DB in Resetlogs upgrade
BKUPDATA_ORAVER=`sed -n 2p /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/oraclever.lst`
if [ ""${BKUPDATA_ORAVER} = "11.2.0.3" ];
then
   sqlplus -S /nolog << SQLEOF2
   connect / as sysdba
   alter database open resetlogs ;
SQLEOF2
else
   sqlplus -S /nolog << SQLEOF2
   connect / as sysdba
   alter database open resetlogs upgrade;
SQLEOF2
fi

exit 0
