#************************************************************************************#
#         Script : packrcs.sh                                                        #
#         Purpose: To create RCS Schema data dump.                                   #
#         Usage  : sh rcsexport.sh <SID>                                               #
#         Date   : 2012/02/26                                                        #
#************************************************************************************#
#!/bin/sh
ORACLE_SID=$1
BACKUP_DIR=`pwd`
if [ "$ORACLE_SID" = "" ]; then
  echo ""
  echo "Database SID defaulted to ttv."
  ORACLE_SID="ttv"
fi
mkdir -p ${BACKUP_DIR}
rm -f "${BACKUP_DIR}/rcs_data.dmp" >> /dev/null
rm -f "${BACKUP_DIR}/rcs_packdata.log" >> /dev/null
RCS_COUNT=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username='RCS';
  exit
SQL1
)
if [ "${RCS_COUNT}" -eq 1 ]; then
  echo "******************************************************************************"
  echo ""
  echo "Running the script, please wait...!"
$ORACLE_HOME/bin/sqlplus -s /nolog<<SQEOF
   connect / as sysdba
   set verify off
   set feedback on
   set serveroutput on
   begin
     for I in (select 'ALTER INDEX '||TABLE_OWNER||'.'|| INDEX_NAME||' REBUILD' rb_indexes
                 from DBA_INDEXES
                where TABLE_OWNER in ('RCS','RCSARCHIVE')
                  and INDEX_TYPE='NORMAL'
                  and table_name not like '%\$%' 
                  and table_name not like 'SYS%'
                  and STATUS = 'UNUSABLE'
              )
     loop
       execute immediate(i.rb_indexes);
     end loop;
   exception
     when OTHERS then
       dbms_output.put_line('*** Error'||substr(sqlerrm,1,200));
   end;
   /
   BEGIN
      execute immediate 'DROP DIRECTORY RCSBACKUPDIR';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   CREATE DIRECTORY RCSBACKUPDIR AS '${BACKUP_DIR}';
   exit
SQEOF
expdp \"\/\ as\ sysdba\" directory=rcsbackupdir dumpfile=rcs_data.dmp logfile=rcs_packdata.log schemas=RCS,RCSARCHIVE 
$ORACLE_HOME/bin/sqlplus -s /nolog<<EOF  
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback off
   BEGIN
      execute immediate 'DROP DIRECTORY RCSBACKUPDIR';
   END;
   /
EOF
else
  echo ""
  echo "RCS DB schema not found, contact DBA for further assistance...."
  echo ""
  exit 1
fi

exit
