#************************************************************************************#
#         Script : unpackrcs.sh                                                      #
#         Purpose: To load datga dump into RCS Schema.                               #
#         Usage  : sh rcsimport.sh <SID>                                             #
#         Date   : 2012/02/26                                                        #
#************************************************************************************#
#!/bin/sh
ORACLE_SID=$1
BACKUP_DIR=`pwd`
if [ ! -f "${BACKUP_DIR}/rcs_data.dmp" ]; then
  echo ""
  echo "RCS data dump file not exists, please verify and try again ...!"
  echo ""
  exit 1
fi
if [ "$ORACLE_SID" = "" ]; then
  echo ""
  echo "Database SID defaulted to ttv."
  ORACLE_SID="ttv"
fi
RCS_COUNT=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username='RCS';
  exit
SQL1
)
if [ "${RCS_COUNT}" -eq 1 ]; then

DB_CONS=$(sqlplus -S /nolog<<EOFSQL
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM v\$session WHERE username in ('RCS','RCSARCHIVE') and status <> 'KILLED';
  exit
EOFSQL
)

if [ "$DB_CONS" -gt 0 ]; then
  echo ""
  echo "Please close RCS service on the app server and try again....!"
  echo ""
  exit 1
fi

  echo "******************************************************************************"
  echo ""
  echo "RCS Data load started, please wait...!"


$ORACLE_HOME/bin/sqlplus -s /nolog<<SQEOF
   connect / as sysdba
   set verify off
   set feedback off
   set serveroutput on
   BEGIN
      execute immediate 'DROP USER RCS CASCADE';
   END;
   /
   BEGIN
      execute immediate 'DROP USER RCSARCHIVE CASCADE';
   EXCEPTION
      when others then
        dbms_output.put_line('*** Error '||substr(SQLERRM,1,100));
   END;
   /
   BEGIN
      execute immediate 'DROP DIRECTORY RCSBACKUPDIR';
   EXCEPTION
      WHEN others THEN null;
   END;
   /
   CREATE DIRECTORY RCSBACKUPDIR AS '${BACKUP_DIR}';
   exit
SQEOF
impdp \"\/\ as\ sysdba\" directory=rcsbackupdir dumpfile=rcs_data.dmp logfile=rcs_unpackdata.log schemas=RCS,RCSARCHIVE ACCESS_METHOD=EXTERNAL_TABLE 
$ORACLE_HOME/bin/sqlplus -s /nolog<<EOF  
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback on
   spool "${BACKUP_DIR}/rcs_unpackdata.log" append
   BEGIN
      execute immediate 'DROP DIRECTORY RCSBACKUPDIR';
   END;
   /
   grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCS;
   grant all on dbms_xmlschema to RCS;
   grant all on dbms_errlog to RCS;
   grant create database link to RCS;
   grant all on directory tstvxmldir to public,rcs;
   grant create database link to RCS;
   grant execute on tstvdb to RCS;
   spool off
EOF
RCSARC_COUNT=$(sqlplus -S /nolog<<PQR
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM dba_users WHERE username='RCSARCHIVE';
  exit
PQR
)
if [ "${RCSARC_COUNT}" -eq 1 ]; then
  $ORACLE_HOME/bin/sqlplus -s /nolog<<XYZ
   connect / as sysdba
   set serveroutput on
   set verify off
   set feedback on
   spool "${BACKUP_DIR}/rcs_unpackdata.log" append
   grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCSARCHIVE;
   grant all on dbms_xmlschema to RCSARCHIVE;
   grant all on dbms_errlog to RCSARCHIVE;
   grant create database link to RCSARCHIVE;
   grant references on rcs.schedule to rcsarchive;
   grant references on rcs.program to rcsarchive;
   grant references on rcs.station to rcsarchive;
   grant references on rcs.rtc_pool to rcsarchive;
   grant references on rcs.headend to rcsarchive;
   grant references on rcs.rm to rcsarchive;
   grant references on rcs.right to rcsarchive;
   grant references on rcs.ENTITY_MAPPING to rcsarchive;
   grant references on rcs.RECORDING_RULES to rcsarchive;
   grant references on rcs.ERROR_CODE to rcsarchive;
   spool off
XYZ

fi

else
  echo ""
  echo "RCS DB schema not found, contact DBA for further assistance...."
  echo ""
  exit 1
fi

exit
