##############################################################################
##                                                                          ##
## Script to create db instances/alter existing DB instance Memory settings ##
##                                                                          ##
##############################################################################
#!/bin/sh
DBCA_LOG=log_create_inst.log
INSTALL_DIR=/home/oracle/scripts/dbca
ORACLE_HOME="/opt/oracle/product/11.2.0/db_1"
DB_NAME=$1
DBSIZE=$2

if [ `whoami` != "root" ]; then
   echo "************************************************************************************"
   echo " Only root user can run this script. Please log in as a root user and try again...!" 
   echo "************************************************************************************"
   exit 1
fi
echo "*************************************************************************"
echo " Script started at $(date)"
echo ""
if [ "$DB_NAME" = "" ]; then
   echo "Please enter the database Name:"
   echo "(Suggestion: When creating a new instance, use six characters name"
   echo "with NO special characters, blank spaces and upper case letters)"
   read DB_NAME
fi
if [ "$DB_NAME" = "" ]; then
   echo "*****************************************************************"
   echo "DB_NAME is manditory to create the Database instance"
   echo "Please try again!"
   echo "*****************************************************************"
   exit 1
fi

if [ "$DBSIZE" = "" ]; then
   echo "Enter the memory size (Suggestion: 800M for DEV/ 48G for PROD):"
   read DBSIZE
fi
if [ "$DBSIZE" = "" ]; then
   echo "*****************************************************************"
   echo "DBSIZE is manditory to create the Database instance"
   echo "Please try again!"
   echo "*****************************************************************"
   exit 1
fi
DB_SIZE=$(echo $DBSIZE | tr '[:lower:]' '[:upper:]')

length=$(expr $(expr length $DB_SIZE) - 1 )
DB_SIZE_UNIT=${DB_SIZE:$length:1}
DB_SIZE_NUM=`expr substr $DB_SIZE 1 $length`

if [ $DB_SIZE_UNIT = "G" ]; then
   DB_SIZE_NUM=$(echo "scale=0;$DB_SIZE_NUM * 1024"|bc )
   for bash_rnum in $(printf %.0f $DB_SIZE_NUM); do
      DB_SIZE_NUM=$bash_rnum
   done
   DB_SIZE_UNIT="M"
   DB_SIZE=$DB_SIZE_NUM$DB_SIZE_UNIT
fi

PGASIZE=$(echo "scale=0;$DB_SIZE_NUM / 8"|bc )
for bash_rounded_number in $(printf %.0f $PGASIZE); do
  PGA_SIZE=$bash_rounded_number
done

SGASIZE=$(echo "scale=0;$DB_SIZE_NUM * 7/8"|bc )
for bash_rounded_number in $(printf %.0f $SGASIZE); do
  SGA_SIZE=$bash_rounded_number
done

sed -i "/kernel.shmall =[.]*/d" /etc/sysctl.conf
grep -q ^kernel.shmall /etc/sysctl.conf
if [ $? -ne 0 ]; then
   echo "kernel.shmall = 12582912" >> /etc/sysctl.conf
fi

grep -q ^kernel.sem /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "kernel.sem = 250 32000 100 128" >> /etc/sysctl.conf
fi

sed -i "/kernel.shmmax =[.]*/d" /etc/sysctl.conf
grep -q ^kernel.shmmax /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "kernel.shmmax = 51539607552" >> /etc/sysctl.conf
        #echo "kernel.shmmax = 2147483648" >> /etc/sysctl.conf
fi

grep -q ^kernel.shmmni /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "kernel.shmmni = 4096" >> /etc/sysctl.conf
fi

grep -q ^net.ipv4.ip_local_port_range /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "net.ipv4.ip_local_port_range = 9000 65500" >> /etc/sysctl.conf
fi

grep -q ^net.core.rmem_default /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "net.core.rmem_default = 262144" >> /etc/sysctl.conf
fi

grep -q ^net.core.rmem_max /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "net.core.rmem_max = 4194304" >> /etc/sysctl.conf
fi

grep -q ^net.core.wmem_default /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "net.core.wmem_default = 262144" >> /etc/sysctl.conf
fi

grep -q ^net.core.wmem_max /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "net.core.wmem_max = 1048586" >> /etc/sysctl.conf
fi

grep -q ^fs.aio-max-nr /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "fs.aio-max-nr = 1048576" >> /etc/sysctl.conf
fi

sed -i "/fs.file-max =[.]*/d" /etc/sysctl.conf
grep -q ^fs.file-max /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "fs.file-max = 6815744" >> /etc/sysctl.conf
fi

grep -q ^vm.hugetlb_shm_group /etc/sysctl.conf
if [ $? -ne 0 ]; then
        echo "vm.hugetlb_shm_group = 1000" >> /etc/sysctl.conf
fi

TOTAL_MEMORY=$(echo "scale=0;$(cat /proc/meminfo | grep MemTotal | awk '{print $2}' ) /1024"|bc)
ORA_MEMORY=$(printf %.0f $(echo "scale=0;${TOTAL_MEMORY}*2/3"|bc))

sed -i "/vm.nr_hugepages =[.]*/d" /etc/sysctl.conf
grep -q ^vm.nr_hugepages /etc/sysctl.conf
if [ $? -ne 0 ]; then
   if [ ${ORA_MEMORY} -gt 42000 ]; then
      echo "vm.nr_hugepages = 21510" >> /etc/sysctl.conf
   elif [ ${ORA_MEMORY} -gt 15360 ]; then
      echo "vm.nr_hugepages = 7170" >> /etc/sysctl.conf
   else
      echo "#vm.nr_hugepages = 7170" >> /etc/sysctl.conf
   fi
fi

grep -q -G "oracle.*soft.*nproc.*2047" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "oracle    soft    nproc   2047" >> /etc/security/limits.conf
fi

grep -q -G "oracle.*hard.*nproc.*16384" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "oracle    hard    nproc   16384" >> /etc/security/limits.conf
fi

grep -q -G "oracle.*soft.*nofile.*1024" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "oracle    soft    nofile  1024" >> /etc/security/limits.conf
fi

grep -q -G "oracle.*hard.*nofile.*65536" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "oracle    hard    nofile  65536" >> /etc/security/limits.conf
fi

grep -q -G "\*.*soft.*memlock.*94371840" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "*         soft    memlock 94371840" >> /etc/security/limits.conf
fi

grep -q -G "\*.*hard.*memlock.*94371840" /etc/security/limits.conf
if [ $? -ne 0 ]; then
        echo "*         hard    memlock 94371840" >> /etc/security/limits.conf
fi

grep -q -G "session.*required.*pam_limits.so" /etc/pam.d/login
if [ $? -ne 0 ]; then
        echo "session   required        pam_limits.so" >> /etc/pam.d/login
fi

/sbin/sysctl -p > /dev/null

su - oracle -c "mkdir -p \${ORACLE_HOME}/dbs/arch"

echo "*************************************************************************"
echo "  Your DB_NAME is ${DB_NAME} and DB_SIZE is ${DBSIZE}" 
echo "*************************************************************************"

echo " ${DB_NAME} DB instance creation/ modification started for ${DBSIZE} foot print" > ${INSTALL_DIR}/${DBCA_LOG}
ORACLE_SID=$DB_NAME
grep -q ${ORACLE_SID} /etc/oratab
if [ $? -ne 0 ]; then
   cp -f ${INSTALL_DIR}/ttv.dbc ${ORACLE_HOME}/assistants/dbca/templates/ttv.dbc
   cp -f ${INSTALL_DIR}/ttv.dfb ${ORACLE_HOME}/assistants/dbca/templates/ttv.dfb
   cp -f ${INSTALL_DIR}/ttv.ctl ${ORACLE_HOME}/assistants/dbca/templates/ttv.ctl
   chown oracle:oinstall ${ORACLE_HOME}/assistants/dbca/templates/ttv.*
   if [ -f ${ORACLE_HOME}/assistants/dbca/templates/ttv.dbc ]; then
     echo "Creating new instance $DB_NAME will take several minutes.  Please wait.....!"
     echo " pga_size=${PGA_SIZE}   sga_size=${SGA_SIZE}"
     sed -e "s/DB_NAME/$DB_NAME/g" -e "s/PGA_SIZE/$PGA_SIZE/g" -e "s/SGA_SIZE/$SGA_SIZE/g" < ${INSTALL_DIR}/dbca_template.rsp > /home/oracle/scripts/dbca/dbca.rsp
     su - oracle -c "\${ORACLE_HOME}/bin/dbca -silent -createDatabase -responseFile /home/oracle/scripts/dbca/dbca.rsp" 2>&1 | tee ${INSTALL_DIR}/${DBCA_LOG}
su - oracle -c "sqlplus -s /nolog <<EOF10
          conn / as sysdba
          set pages 0
          set feedback off
          @?/rdbms/admin/prvtstat.plb
          exit
EOF10"
     #echo "${ORACLE_SID}:${ORACLE_HOME}:N" >> /etc/oratab
     cp /etc/oratab ${INSTALL_DIR}/oratab_old
     ORATAB_ENTRY=`sed -e "s/:N/:Y/" < /etc/oratab | grep $DB_NAME`
     sed "s/^.*$DB_NAME.*//" < /etc/oratab > ${INSTALL_DIR}/oratab_local
     echo "${ORATAB_ENTRY}" >> ${INSTALL_DIR}/oratab_local
     sed '/^$/d' ${INSTALL_DIR}/oratab_local > /etc/oratab

     check_db_stat=`ps -ef|grep ${ORACLE_SID}|grep pmon|wc -l`;
     instance_found=`expr $check_db_stat`
     if [ $instance_found -gt 0 ];
     then
        echo "Changing user profile........."
        su - oracle -c "sh ${INSTALL_DIR}/chg_prof.sh ${ORACLE_SID}" 2>&1 | tee -a ${INSTALL_DIR}/${DBCA_LOG} 
     fi

     echo "*************************************************************************"
     if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${DBCA_LOG}"
     then
         echo "Database instance ${DB_NAME} creation got Failed!"
         echo "  Please check ${INSTALL_DIR}/${DBCA_LOG} file for errors.....!"
         echo "*************************************************************************"
         exit 1
     elif grep -q "100\% complete" "${INSTALL_DIR}/${DBCA_LOG}" 
     then
         echo "  Script completed at $(date)"
         echo "  Database instance ${DB_NAME} created SUCCESSFULLY..."
         echo "*************************************************************************"
         exit 0
     else
         echo "Database instance ${DB_NAME} creation got Failed!"
         echo "  Please check ${INSTALL_DIR}/${DBCA_LOG} file for errors.....!"
         echo "*************************************************************************"
         exit 1 
     fi
   else
     echo "Database template file is missing. Please contact DBA for further assistance ....!" 
     exit 1
   fi
else

   check_stat=`ps -ef|grep ${ORACLE_SID}|grep pmon|wc -l`;
   oracle_num=`expr $check_stat`
   if [ $oracle_num -lt 1 ];
   then
      sh ${INSTALL_DIR}/init_ora_build.sh ${DB_NAME} ${PGA_SIZE} ${SGA_SIZE} ${INSTALL_DIR} 2>&1 | tee ${INSTALL_DIR}/${DBCA_LOG}
      #echo "Parameter file created successfully and database will be started using this pfile, please WAIT..."
      su - oracle -c "sh ${INSTALL_DIR}/db_strt_use_pfile.sh ${DB_NAME}" 2>&1 | tee ${INSTALL_DIR}/${DBCA_LOG}
   else
     
      DB_ROLE=$(su - oracle -c "sqlplus -s /nolog <<EOF2
          conn / as sysdba
          set pages 0
          set feedback off
          select trim(database_role) from v\\\$database;
          exit
EOF2")
      if [ -n "${DB_ROLE}" ]
      then
         case ${DB_ROLE} in
            "PHYSICAL STANDBY" )
               DB_OPEN_MODE="mount"
         ;;
         * )
              DB_OPEN_MODE=""
         esac
      fi

      #echo "$ORACLE_SID Database instance memory variables changing is in progress...."
      su - oracle -c "sh ${INSTALL_DIR}/db_alt_mem.sh ${DB_NAME} ${PGA_SIZE} ${SGA_SIZE} ${DB_OPEN_MODE}" 2>&1 | tee ${INSTALL_DIR}/${DBCA_LOG}	
      if [ "${DB_OPEN_MODE}" = "" ] 
      then
         su - oracle -c "sh ${INSTALL_DIR}/chg_prof.sh ${ORACLE_SID}" 2>&1 | tee -a ${INSTALL_DIR}/${DBCA_LOG} 
      fi
   fi
   sed -i "/ORA-01109[.]*/d" ${INSTALL_DIR}/${DBCA_LOG}
   echo "*************************************************************************"
   if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${DBCA_LOG}" 
   then
       echo "Database ${DB_NAME} instance memory changing got Failed!"
       echo "Please check ${INSTALL_DIR}/${DBCA_LOG} file for any errors"
       echo "*************************************************************************"
       exit 1
    else
       echo "Script completed at $(date)"
       echo "Database ${DB_NAME} instance memory modification completed SUCCESSFULLY..."
       echo "*************************************************************************"
       exit 0
   fi
fi
