#!/bin/sh
export ORACLE_SID=$1
PGA_SIZE=$2
SGA_SIZE=$3
DB_OPEN_MODE="$4"

sqlplus -S /nolog<<SQL1
connect / as sysdba
set pages 0
set feedback off

/* Setting ASMM parameter and nullifying AMM parameters */
ALTER SYSTEM SET PGA_AGGREGATE_TARGET=${PGA_SIZE}M scope=spfile;
ALTER SYSTEM SET SGA_TARGET=${SGA_SIZE}M scope=spfile;

declare
  v1 number;
begin
  select nvl(value,0) into v1 from v\$spparameter where name like 'memory_max_target';
  if (v1 != 0) then
      execute immediate 'ALTER SYSTEM RESET memory_max_target SCOPE=SPFILE';
  end if;

  select nvl(value,0) into v1 from v\$spparameter where name like 'memory_target';
  if (v1 != 0) then
      execute immediate 'ALTER SYSTEM RESET memory_target SCOPE=SPFILE';
  end if;

  select nvl(value,0) into v1 from v\$spparameter where name like 'sga_max_size';
  if (v1 != 0) then
      execute immediate 'ALTER SYSTEM RESET sga_max_size SCOPE=SPFILE';
  end if;
end;
/

shut immediate
startup ${DB_OPEN_MODE}

exit
SQL1

exit 0
