##############################################################################
##                                                                          ##
## Name      : oracle_init_setup.sh                                         ##
##                                                                          ##
## Script to : Creates ttv instance during database appliance first boot.   ##
##             This script also completes the db instance required setup.   ##
##                                                                          ##
## created on: 05/18/2012                                                   ##
##                                                                          ##
##############################################################################
#!/bin/sh
INSTALL_DIR="/home/oracle/scripts/dbca"
ORACLE_HOME="/opt/oracle/product/11.2.0/db_1"

# if [ -f /opt/oracle/backup/scripts/rman_backup.ksh ]; 
# then
   # echo "This script was already ran on this server"
   # exit 1
# else
   # echo ""
   # echo "Script started at $(date)....."
# fi

# mkdir -p /home/oracle/scripts
# chown oracle:oinstall -R /home/oracle

# extract the oracle_rdbms_install tar.


# tar -xzvf /home/oracle/scripts/dbca.tar.gz
ln -s /usr/bin /usr/local/bin
cp -f ${INSTALL_DIR}/oracle_service /etc/init.d/oracle
chown root:root /etc/init.d/oracle
chmod 755 /etc/init.d/oracle 
chkconfig oracle on

cp -f ${INSTALL_DIR}/oracle_profile /home/oracle/.bash_profile
chown oracle:oinstall /home/oracle/.bash_profile

#echo "127.0.0.1		`hostname`" >> /etc/hosts

mkdir -p $ORACLE_HOME/dbs/arch
chown oracle:oinstall $ORACLE_HOME/dbs/arch

mkdir -p /opt/oracle/backup/scripts
chown -R oracle:oinstall /opt/oracle/

mkdir -p /opt/oracle/oradata
chown -R oracle:oinstall /opt/oracle/oradata

mkdir -p /opt/oracle/admin
chown -R oracle:oinstall /opt/oracle/admin

cp -f ${INSTALL_DIR}/ms.sql /home/oracle/scripts/ms.sql
chown oracle:oinstall /home/oracle/scripts/ms.sql

cp -f ${INSTALL_DIR}/rman_backup.ksh /opt/oracle/backup/scripts/rman_backup.ksh
cp -f ${INSTALL_DIR}/rman_backup_arch.ksh /opt/oracle/backup/scripts/rman_backup_arch.ksh
chown oracle:oinstall /opt/oracle/backup/scripts/rman_backup*.ksh

echo "# Full DB Backups. Set to run once every Sunday at 01:00 AM " > ${INSTALL_DIR}/ora_crontab_entry
echo "#0 1 * * sun /opt/oracle/backup/scripts/rman_backup.ksh DISK" >> ${INSTALL_DIR}/ora_crontab_entry
echo "# Archive Log Backups and Management" >> ${INSTALL_DIR}/ora_crontab_entry
echo "#0 0,6,12,18 * * * /opt/oracle/backup/scripts/rman_backup_arch.ksh DISK" >> ${INSTALL_DIR}/ora_crontab_entry
crontab -u oracle ${INSTALL_DIR}/ora_crontab_entry

cp -f ${INSTALL_DIR}/glogin.sql $ORACLE_HOME/sqlplus/admin/glogin.sql
chown oracle:oinstall $ORACLE_HOME/sqlplus/admin/glogin.sql

cp -f ${INSTALL_DIR}/ttv.ctl $ORACLE_HOME/assistants/dbca/templates/ttv.ctl
cp -f ${INSTALL_DIR}/ttv.dfb $ORACLE_HOME/assistants/dbca/templates/ttv.dfb
cp -f ${INSTALL_DIR}/ttv.dbc $ORACLE_HOME/assistants/dbca/templates/ttv.dbc
chown oracle:oinstall $ORACLE_HOME/assistants/dbca/templates/ttv.* 

sed -i 's/net.bridge.bridge-nf-call-ip6tables = 0/# net.bridge.bridge-nf-call-ip6tables = 0/g' /etc/sysctl.conf
sed -i 's/net.bridge.bridge-nf-call-iptables = 0/# net.bridge.bridge-nf-call-iptables = 0/g' /etc/sysctl.conf
sed -i 's/net.bridge.bridge-nf-call-arptables = 0/# net.bridge.bridge-nf-call-arptables = 0/g' /etc/sysctl.conf

sh /home/oracle/scripts/dbca/create_modify_instance.sh ttv 48G

service oracle restart

echo ""
echo "Script ended at $(date)......"
echo ""
