#####################################################################
##                     Data Guard Setup Script                     ##           
#####################################################################
#!/bin/sh

PDBID=$1
PDBIP=$2
SDBID=$3
SDBIP=$4
DG_SETUP_LOG=$5
INSTALL_DIR=$6

cd ${INSTALL_DIR}

echo " "
echo "Data Guard setup started at "$(date)
echo " "
echo "********************************************************************"
echo "**********  Step(1)  Validating the Parameters ********************"
echo "********************************************************************"
echo " "

sh ${INSTALL_DIR}/validparams.sh "$PDBID" "$PDBIP" "$SDBID" "$SDBIP" "$DG_SETUP_LOG" "$INSTALL_DIR" 
if [ $? -ne 1 ]; then
   echo " PrimaryDB ID/ IP : $PDBID  / $PDBIP "
   echo ""
   echo " StandbyDB ID/ IP : $SDBID  / $SDBIP "
   echo " "
else
   exit 0
fi

echo " "
echo "********************************************************************"
echo "*********** Step(2) Check the pre requisites ***********************"
echo "********************************************************************"
echo " "

sh ${INSTALL_DIR}/prereq.sh "$PDBIP" "$SDBIP"

MCIP=$(ping `hostname` -c 1 |grep PING| awk '{print $3}'|sed -e 's/(//'| sed -e 's/)//')
if [ "$MCIP" = "" ]; then
    echo "Inside the loop.....!"
    MCIP=$(grep `uname -n` /etc/hosts | egrep -v '^#'| awk '{print $1}')
fi
echo $MCIP  $PDBIP  $SDBIP

if [ "$MCIP" = "$PDBIP" ]; then
   echo " "
   echo "********************************************************************"
   echo "************ Step(3) Primary Database setup started ****************"
   echo "********************************************************************"
   echo " "

   sh ${INSTALL_DIR}/ppd.sh "$PDBID" "$PDBIP" "$SDBID" "$SDBIP" "$INSTALL_DIR" 
   if [ $? -gt 0 ]; then
      echo "There is an error, exiting the script .....!"
      exit 1
   fi

# create the standby file on primary

   echo " "
   echo "********************************************************************"
   echo "************ Step(4) Standby Database setup started ****************"
   echo "********************************************************************"
   echo " "

   U_ORACLE_SID=$(echo $ORACLE_SID | tr '[:lower:]' '[:upper:]')
   i=0
   for file in $(ls -t /opt/oracle/oradata/${U_ORACLE_SID}/controlfile/*.ctl); do
      if [ $i = 0 ]; then
         CONTROL_FILES=$file
         i=`expr $i + 1`
#     else
#        CONTROL_FILES=$CONTROL_FILES","$file
      fi
   done

   echo "Enter the oracle password for the Standby box :"
   ssh "oracle@${SDBIP}" "sh ${INSTALL_DIR}/psd.sh $PDBID $PDBIP $SDBID $SDBIP $CONTROL_FILES $INSTALL_DIR" 

   sed -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" < ${INSTALL_DIR}/refresh_db_standby_template.rman > ${INSTALL_DIR}/refresh_db_standby.rman
   chmod 744 refresh_db_standby.rman
   rman @refresh_db_standby.rman
   
   #Start the Data Guard Redo Apply Service on Standby DB server 

#connect sys/n2bbsys@${SDBID} as sysdba
sqlplus /nolog <<EOFSSQL
connect sys/n2bbsys@${SDBID} as sysdba
ALTER DATABASE RECOVER MANAGED STANDBY DATABASE USING CURRENT LOGFILE DISCONNECT FROM SESSION;
EOFSSQL

   echo " "
   echo "********************************************************************"
   echo "************ Step(5) Continuing to Data Guard Broker setup *********"
   echo "********************************************************************"
   echo " "

   sed -e "s/PDBID/${PDBID}/g;" -e "s/SDBID/${SDBID}/g;" < ${INSTALL_DIR}/dgb_setup_template.sh > ${INSTALL_DIR}/dgb_setup.sh
   chmod 744 dgb_setup.sh
   sleep 30
   sed -e "s/SDBID/${SDBID}/g;" < ${INSTALL_DIR}/remove_sdb_config_template.sh > ${INSTALL_DIR}/remove_sdb_config.sh
   chmod 744 remove_sdb_config.sh
   sh remove_sdb_config.sh
   sleep 30
   sh dgb_setup.sh
   sleep 10
   dgmgrl -silent sys/n2bbsys "SHOW CONFIGURATION"
else
   echo "IPs entered not matching with this machine IP, PLEASE TRY AGAIN .......!"
   exit 1
fi

echo " "
echo "Data Guard setup completed at "$(date)
exit 0
