#!/bin/sh

echo "******* 3) Prepare Primary Database..."
PDBID=$1
PDBIP=$2
SDBID=$3
SDBIP=$4
INSTALL_DIR=$5
ORACLE_SID="ttv"
DIR_NET_INST="$ORACLE_HOME/network/install"
DIR_INIT_PARM="$ORACLE_HOME/dbs"
DIR_LSTNR="$ORACLE_HOME/network/admin"

#Prepare primary DB:

#Remove the Data Guard Broker configurations if any.
dgmgrl -silent sys/n2bbsys "REMOVE CONFIGURATION"

# configure the the netca_standby.rsp file.
sed -e "s/ORACLE_SID/${ORACLE_SID}/g" -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" -e "s/PDBIP/${PDBIP}/g" -e "s/SDBIP/${SDBIP}/g" < ${INSTALL_DIR}/netca_template.rsp > ${DIR_NET_INST}/netca.rsp
lsnrctl stop
if [ -f ${DIR_LSTNR}/listener.ora} ] 
then
   echo "Listener file exists"
   mv ${DIR_LSTNR}/listener.ora ${DIR_LSTNR}/listener_old.ora  
fi

# Stop the Listener and run the netca tool
netca /silent -responsefile ${DIR_NET_INST}/netca.rsp
lsnrctl start

# Setup the primary and secondary db names in Primary DB parameter file (initttv_primary.ora) 
check_db_stat=`ps -ef|grep $ORACLE_SID|grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
if [ $oracle_num -gt 0 ];
then
   echo "$ORACLE_SID Database is running...."
   sqlplus -s / as sysdba << END_SQL
   shut immediate
END_SQL
echo "Shutdown the database successfully....."
fi

# Create the spfile from parameter file.
# Make sure the sp file exists.
# Bounce the primary database.
# Turn-on the database to archivelog.
# Display the Archive log folder. 

U_ORACLE_SID=$(echo $ORACLE_SID | tr '[:lower:]' '[:upper:]')
i=0
for file in $(ls -t /opt/oracle/oradata/${U_ORACLE_SID}/controlfile/*.ctl); do
  if [ $i = 0 ]; then
    CONTROL_FILES=$file
    i=`expr $i + 1`
#  else
#    CONTROL_FILES=$CONTROL_FILES","$file
  fi
done
sed -e "s/ORACLE_SID/$ORACLE_SID/g" -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" < ${INSTALL_DIR}/initttv_primary_template.ora > ${DIR_INIT_PARM}/initttv.ora

# adding control files to parameter file.
if [ -f ${DIR_INIT_PARM}/initttv.ora ]; then
  sed -i "/control_files[.]*/d" ${DIR_INIT_PARM}/initttv.ora
  grep -q -G "\*.*control_files" ${DIR_INIT_PARM}/initttv.ora
  if [ $? -ne 0 ]; then 
    echo "*.control_files='"${CONTROL_FILES}"'" >> ${DIR_INIT_PARM}/initttv.ora
  fi
else
  echo "init.ora file not exists...."
  exit 1
fi

check_db_stat=`ps -ef|grep ${ORACLE_SID}|grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
#echo $oracle_num
if [ $oracle_num -eq 0 ];
then
   echo "$ORACLE_SID Database is not running...."
   sqlplus -s / as sysdba << END_SQL
   startup pfile=$DIR_INIT_PARM/initttv.ora
   create spfile from pfile;
   shutdown immediate
   startup
   show parameter spfile;
   shutdown immediate
   startup mount
   alter database archivelog;
   alter database open;
   archive log list
END_SQL
echo "Started the database successfully....."
fi

# Shutdown the db using dbshut command
# dbshut $ORACLE_HOME

check_db_stat=`ps -ef|grep ${ORACLE_SID}|grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
#echo $oracle_num
if [ $oracle_num -eq 0 ];
then
   echo "Database can not be restarted, database should be up and running for setting up the data guard. "
   exit 1
else
   #check the standby logs on the database, if not exists create them.
   sh ${INSTALL_DIR}/recreate_standby_logs.sh "${ORACLE_SID}"
fi

# Add sid_list_listener in the listener.ora file and restart the lister.
sed -e "s/ORACLE_SID/${ORACLE_SID}/g" -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" < ${INSTALL_DIR}/list_lstnr_template.ora > ${INSTALL_DIR}/list_lstnr.ora
CNT=`cat ${DIR_LSTNR}/listener.ora |grep SID_LIST_LISTENER|wc -l`
if [ $CNT = 0 ]; then
   echo "Adding SID_LIST_LISTENER parameter to listener.ora file"
   cat ${INSTALL_DIR}/list_lstnr.ora >> ${DIR_LSTNR}/listener.ora
   lsnrctl stop
   lsnrctl start
fi

#Adding write permisson on tnsnames.ora for ATT
chmod 777 ${ORACLE_HOME}/network/admin  2> /dev/null
chmod 777 ${ORACLE_HOME}/network/admin/tnsnames.ora 2> /dev/null

exit 0
