#!/bin/sh

source /home/oracle/.bash_profile

echo "Preparing Physical Standby DB "

PDBID=$1
PDBIP=$2
SDBID=$3
SDBIP=$4
CONTROL_FILES=$5
INSTALL_DIR=$6
ORACLE_SID="ttv"
DIR_NET_INST="$ORACLE_HOME/network/install"
DIR_INIT_PARM="$ORACLE_HOME/dbs"
DIR_LSTNR="$ORACLE_HOME/network/admin"


# Logon to standby database as root user.

# Disable auto-start oracle scripti (as a root user).
#chkconfig oracle off

# As oracle user, shutdown the secondary database using dbshut.
dbshut $ORACLE_HOME

rm -fR /opt/oracle/standbyoradata.tar.gz
tar -czvf /opt/oracle/standbyoradata.tar.gz /opt/oracle/oradata
rm -fR /opt/oracle/oradata
mkdir -p /opt/oracle/oradata/TTV/controlfile

# Stop the Listener 
if [ -f ${DIR_LSTNR}/listener.ora ]; then
   echo "Listener file exists"
   mv ${DIR_LSTNR}/listener.ora ${DIR_LSTNR}/listener_old.ora
fi

# Setup Listener and TNSNAMES in Standby DB NETCA response file.
sed -e "s/ORACLE_SID/${ORACLE_SID}/g" -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" -e "s/PDBIP/${PDBIP}/g" -e "s/SDBIP/${SDBIP}/g" < ${INSTALL_DIR}/netca_template.rsp > ${DIR_NET_INST}/netca.rsp

# Run the NETCA for the Standby DB.
netca /silent -responsefile ${DIR_NET_INST}/netca.rsp

# copy the standby parameter file as initttv.ora file.
sed -e "s/ORACLE_SID/${ORACLE_SID}/g"  -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" < ${INSTALL_DIR}/initttv_standby_template.ora > ${DIR_INIT_PARM}/initttv.ora

# adding control files to parameter file.
if [ -f ${DIR_INIT_PARM}/initttv.ora ]; then
  sed -i "/control_files[.]*/d" ${DIR_INIT_PARM}/initttv.ora
  grep -q -G "\*.*control_files" ${DIR_INIT_PARM}/initttv.ora
  if [ $? -ne 0 ]; then
    echo "*.control_files='"${CONTROL_FILES}"'" >> ${DIR_INIT_PARM}/initttv.ora
  fi
else
  echo "init.ora file not exists...."
  exit 1
fi

check_db_stat=`ps -ef|grep $ORACLE_SID|grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
if [ $oracle_num -gt 0 ];
then
   echo "$ORACLE_SID Database is running, please shutdown the Database and try again....."
   exit 1
fi
   sqlplus -s / as sysdba << END_SQL
      startup nomount pfile=$DIR_INIT_PARM/initttv.ora
END_SQL
echo "Started the database with nomount successfully....."


# Add sid_list_listener in the listener.ora file and restart the lister.
sed -e "s/ORACLE_SID/${ORACLE_SID}/g" -e "s/PDBID/${PDBID}/g" -e "s/SDBID/${SDBID}/g" < ${INSTALL_DIR}/list_lstnr_template.ora > ${INSTALL_DIR}/list_lstnr.ora
CNT=`cat ${DIR_LSTNR}/listener.ora |grep SID_LIST_LISTENER|wc -l`
if [ $CNT = 0 ]; then
   echo "Adding SID_LIST_LISTENER parameter to listener.ora file"
   cat ${INSTALL_DIR}/list_lstnr.ora >> ${DIR_LSTNR}/listener.ora
   lsnrctl stop
   lsnrctl start
fi

#Adding write permisson on tnsnames.ora for ATT
chmod 777 ${ORACLE_HOME}/network/admin  2> /dev/null
chmod 777 ${ORACLE_HOME}/network/admin/tnsnames.ora 2> /dev/null

exit 0
