#!/bin/sh
export ORACLE_SID=$1
sqlplus -s / as sysdba << LOG_SQL
        whenever sqlerror exit 1

declare
  log_count number(4);
  max_grp_no number(4);
begin
  for i in (select * from v\$logfile where type='STANDBY') loop
    dbms_output.put_line (i.group#||') '||i.member);
    dbms_output.put_line ('alter database drop logfile group '||i.group#);   
    execute immediate 'alter database drop logfile group '||i.group#; 
  END LOOP;
  
  select count(*), max(group#) into log_count, max_grp_no from v\$logfile where type ='ONLINE' ;
  log_count:=log_count+1;
  dbms_output.put_line ('log_count='||log_count||', max_grp_no='||max_grp_no); 
  
  for x in log_count..(max_grp_no+log_count) loop
  dbms_output.put_line ('alter database add standby logfile group '||x||' size 200M');
  execute immediate ('alter database add standby logfile group '||x||' size 200M');
  end loop;
end;
/
LOG_SQL

exit

