#####################################################################
##                     Data Guard Setup Script                     ##           
##    Version #    : 1.0                                           ##          
##    Date created : 23-Nov-2010                                   ##
##    Created by   : Suresh Neravati                               ##
#####################################################################
#!/bin/sh
DG_INSTALL_LOG=`hostname`-dataguard-$(date +"%Y%m%d-%H%M%S").log
INSTALL_DIR="/home/oracle/scripts/dg"

if [ `whoami` !=  "oracle" ]; then
   echo "You can run this script as oracle user only, Please try again as oracle user....!"
   exit 1
fi

# obtain the user inputs for Primary and Secondary DBs:

echo -n "Enter primary DB Unique Name [ttv1] : "
read PDBID
echo -n "Enter Primary DB IP : "
read PDBIP
echo -n "Enter Standby DB Unique Name [ttv2] : "
read SDBID
echo -n "Enter Standby DB IP : "
read SDBIP

sh ${INSTALL_DIR}/dgsetup.sh "$PDBID" "$PDBIP" "$SDBID" "$SDBIP" "$DG_SETUP_LOG" "$INSTALL_DIR" 2>&1 | tee -a ${INSTALL_DIR}/${DG_INSTALL_LOG}

exit 0
