#!/bin/sh
DG_SETUP_LOG=$5
INSTALL_DIR=$6

PDBID=$1
PDBIP=$2
SDBID=$3
SDBIP=$4

#echo "****** 1) Validating the parameters .........$PDBID, $PDBIP, $SDBID, $SDBIP"

if [ "$PDBID" = "" ] || [ "$SDBID" = "" ]; then
  echo "Database ids should not be blank, please try again....!"
  exit 1
elif [ "$PDBIP" = "" ] || [ "x$SDBIP" = "" ]; then
  echo "IPs should not be blank, please try again....! "
  exit 1
fi

if [ "$PDBID" = "$SDBID" ]; then
  echo "Please enter different ids for Primary and Standby DBs"
  echo "Please try again!"
  exit 1
fi

if [ "$PDBIP" = "$SDBIP" ]; then
  echo "Please enter different IPs for Primary and Standby DBs"
  echo "Please try again!"
  exit 1
fi

sh validip.sh $PDBIP
if [ $? -eq 1 ]; then
   echo "Primary DB IP is not valid, please try again ....!"
   exit 1
fi
sh validip.sh $SDBIP
if [ $? -eq 1 ]; then
   echo "Standby DB IP is not valid, please try again ....!"
   exit 1
fi

exit 0


