#!/bin/sh
#####################################################################
##    Script Name  : setup_clusterware.sh                          ##
##    Version #    : 1.0                                           ##
##    Date created : 10-Aug-2012                                   ##
##    Created by   : Suresh Neravati                               ##
##    Usage        : sh setup_clusterware.sh                       ##
#####################################################################
#
#install_dir=`pwd`
install_dir="/home/oracle/scripts/rac/clusterware"
sw_dir="/home/oracle/orarac"
cv_dir="/home/oracle/cv_home"
grid_home="/opt/app/11.2.0/grid"
db_home="/opt/app/oracle/product/11.2.0/db_1"
cluster_install_log="cluster_install.log"
cluvfy_log="cluvfy.log"
ss_fom_log="fom.log"
RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"` 
NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`
DBCLUSTERNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_CLUSTER_NAME"`
NODE1_PUBLICIP=`sh ${RAC_CONF_DIR}/get_var_value.sh "NODE1_PUBLIC_IP"`
NODE1_PRIVATEIP=`sh ${RAC_CONF_DIR}/get_var_value.sh "NODE1_PRIVATE_IP"`
SSIP=`sh ${RAC_CONF_DIR}/get_var_value.sh "SHAREDSTORAGE_VIP"`
HOSTNODE=`hostname`
runas=""
if [ `whoami` !=  "root" ]; then
   echo "You can run this script as root user only, Please try again ....!"
   exit 1
fi

echo -e "\n**************************************************************"
echo "     Script started at $(date)"
echo -e "**************************************************************\n"
if [ ${#DBCLUSTERNAME} -gt 15 ]; then
  echo -e "Cluster name should not exceed 15 characters. Please change rac_setup.conf file and try again...!\n"
  exit 1
fi
echo -e "\nSetting up root user equivalance..........\n"
${sw_dir}/grid/sshsetup/sshUserSetup.sh -user root -hosts "${NODE1_HOSTNAME} ${NODE2_HOSTNAME}" -noPromptPassphrase -confirm -advanced
${sw_dir}/grid/sshsetup/sshUserSetup.sh -user root -hosts "${NODE1_HOSTNAME} ${NODE2_HOSTNAME}" -verify
echo -e "\n\nSetting up oracle user equivalance..........\n"
${sw_dir}/grid/sshsetup/sshUserSetup.sh -user oracle -hosts "${NODE1_HOSTNAME} ${NODE2_HOSTNAME}" -noPromptPassphrase -confirm -advanced
${sw_dir}/grid/sshsetup/sshUserSetup.sh -user oracle -hosts "${NODE1_HOSTNAME} ${NODE2_HOSTNAME}" -verify
if [ -f ${sw_dir}/grid/runInstaller ]; then
   ssh "root@${NODE1_HOSTNAME}" "chown -R oracle:oinstall /home/oracle/orarac/;chmod -R 744 /home/oracle/orarac/"
   ssh "root@${NODE2_HOSTNAME}" "chown -R oracle:oinstall /home/oracle/orarac/;chmod -R 744 /home/oracle/orarac/"
   chown -R oracle:oinstall /home/oracle/scripts/rac/clusterware
   chown -R oracle:oinstall /home/oracle/scripts/rac/installoracle
   chown -R oracle:oinstall /home/oracle/scripts/rac/createdb
else 
   echo -e "\nOracle install files are not exists, check /home/oracle/orarac for oracle install files....\n\n"
   exit 1
fi

if [ "${HOSTNODE}" == "" ] || [ "${DBCLUSTERNAME}" == "" ] || [ "${NODE1_HOSTNAME}" == "" ] || [ "${NODE2_HOSTNAME}" == "" ] || [ "${NODE1_PUBLICIP}" == "" ] || [ "${NODE1_PRIVATEIP}" == "" ] || [ "${SSIP}" == "" ]; then
   echo -e "\nPlease check rac_setup.conf file for missing values of clustername, nodenames, public, private and shared storage ip etc. Try again....!\n"
   exit 1
else
   PUBLIC_NWSERIES=`echo ${NODE1_PUBLICIP} | awk -F"." '{ print $1"."$2"."$3".0" }'`
   PRIVATE_NWSERIES=`echo ${NODE1_PRIVATEIP} | awk -F"." '{ print $1"."$2"."$3".0" }'`
   SS_NWSERIES=`echo ${SSIP} | awk -F"." '{ print $1"."$2"."$3".0" }'`
   #echo -e "\n HOSTNODE=${HOSTNODE}  \n DBCLUSTERNAME=$DBCLUSTERNAME \n NODE1_HOSTNAME=$NODE1_HOSTNAME  \n NODE2_HOSTNAME=$NODE2_HOSTNAME  \n PUBLIC_NWSERIES=$PUBLIC_NWSERIES  \n PRIVATE_NWSERIES=$PRIVATE_NWSERIES  \n SS_NWSERIES=${SS_NWSERIES} \n"

   sed -e "s/HOSTNODE/${HOSTNODE}/g" -e "s/DBCLUSTERSCAN/${DBCLUSTERNAME}/g" -e "s/DBCLUSTERNAME/${DBCLUSTERNAME}/g" -e "s/NODE1/${NODE1_HOSTNAME}/g" -e "s/NODE2/${NODE2_HOSTNAME}/g" -e "s/PUBLIC_NW_SERIES/${PUBLIC_NWSERIES}/g" -e "s/PRIVATE_NW_SERIES/${PRIVATE_NWSERIES}/g" -e "s/SS_NW_SERIES/${SS_NWSERIES}/g" < ${install_dir}/grid_template.rsp > ${install_dir}/grid.rsp
fi
if [ -f ${install_dir}/grid.rsp ]; then
   echo -e "\n****************** Running Cluvfy utility ******************\n"
   su - oracle -c "${cv_dir}/bin/cluvfy stage -pre crsinst -n ${NODE1_HOSTNAME},${NODE2_HOSTNAME} -verbose" 2>&1 | tee ${install_dir}/${cluvfy_log}
   echo -e "\nPlease wait until the Clusterware installation completes.....!\n"
   # add the above step for remote machine
   su - oracle -c "export ORACLE_HOME=/opt/app/11.2.0/grid;${sw_dir}/grid/runInstaller -responseFile ${install_dir}/grid.rsp -silent -ignorePrereq -ignoreSysPrereqs -showProgress -waitforcompletion" 2>&1 | tee ${install_dir}/${cluster_install_log}
   mv ${install_dir}/grid.rsp ${install_dir}/grid_old.rsp
   if [ ! -f ${install_dir}/${cluster_install_log} ]
   then
      echo "**************************************************************************************"
      echo " Cluserware script probably failed!  ${install_dir}/${cluster_install_log} file is not exists..!"
      echo "**************************************************************************************"
      exit 1
   else
      if  grep -q "ORA-\|Permission denied\|FATEL" "${install_dir}/${cluster_install_log}"
      then
         echo "**************************************************************************************"
         echo " Cluserware installation probably failed! Check ${INSTALL_DIR}/${cluster_install_log} file for details."
         echo "**************************************************************************************"
         exit 1
      else
         if  grep -q "Successfully Setup Software." "${install_dir}/${cluster_install_log}"
         then
            echo -e "\n**************************************************************************************\n"
            echo -e "\n Running the above scripts as root user, please wait ....!\n"
            ssh "root@${NODE1_HOSTNAME}" "sh /opt/app/oraInventory/orainstRoot.sh"
            ssh "root@${NODE2_HOSTNAME}" "sh /opt/app/oraInventory/orainstRoot.sh"
            ssh "root@${NODE1_HOSTNAME}" "sh ${grid_home}/root.sh"
            ssh "root@${NODE2_HOSTNAME}" "sh ${grid_home}/root.sh"
            su - oracle -c "${grid_home}/cfgtoollogs/configToolAllCommands"
            echo -e "\n**************************************************************************************\n"
            echo -e "\nApplying Oracle grid patches on both the nodes, please wait....\n"
            ssh "root@${NODE1_HOSTNAME}" "rm -rf ${grid_home}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${grid_home};chown -R oracle:oinstall ${grid_home}/OPatch"
            ssh "root@${NODE1_HOSTNAME}" "rm -rf ${db_home}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${db_home};chown -R oracle:oinstall ${db_home}/OPatch"
            ssh "root@${NODE2_HOSTNAME}" "rm -rf ${grid_home}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${grid_home};chown -R oracle:oinstall ${grid_home}/OPatch"
            ssh "root@${NODE2_HOSTNAME}" "rm -rf ${db_home}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${db_home};chown -R oracle:oinstall ${db_home}/OPatch"


            # shared storage failover manager setup
            ssh "root@${NODE1_HOSTNAME}" "${install_dir}/sharedstorage_fom_setup.sh 2>&1 | tee ${install_dir}/${ss_fom_log}"
            ssh "root@${NODE2_HOSTNAME}" "${install_dir}/sharedstorage_fom_setup.sh 2>&1 | tee ${install_dir}/${ss_fom_log}"

            ssh "root@${NODE1_HOSTNAME}" "mkdir -p /home/oracle/cmsappnfs;cp -rf ${install_dir}/cmsappnfs /home/oracle/cmsappnfs;chown -R oracle:oinstall /home/oracle/cmsappnfs;chmod -R 755 /home/oracle/cmsappnfs"
            ssh "root@${NODE2_HOSTNAME}" "mkdir -p /home/oracle/cmsappnfs;cp -rf ${install_dir}/cmsappnfs /home/oracle/cmsappnfs;chown -R oracle:oinstall /home/oracle/cmsappnfs;chmod -R 755 /home/oracle/cmsappnfs"

            # Add the HP failover manager in vmplayer and start as Cluster registry service and NFS service for CMS APP volume
            ${grid_home}/bin/crsctl delete resource vmwarehpfom > /dev/null 2>&1
            ${grid_home}/bin/crsctl delete type vmwarefom > /dev/null 2>&1
            ${grid_home}/bin/crsctl add type vmwarefom -basetype cluster_resource -attr "ATTRIBUTE=ACTION_SCRIPT,TYPE=string,DEFAULT_VALUE=/home/oracle/vmware/FOM/vmwarefom"
            ${grid_home}/bin/crsctl add resource vmwarehpfom -type vmwarefom -attr "AUTO_START=always,CARDINALITY=2,DEGREE=1,CHECK_INTERVAL=3600,DESCRIPTION='HP Failover Manager running in VMPlayer',START_TIMEOUT=60,RESTART_ATTEMPTS=1,HOSTING_MEMBERS='$NODE1_HOSTNAME,$NODE2_HOSTNAME',START_DEPENDENCIES=hard(ora.net1.network),STOP_DEPENDENCIES=hard(ora.net1.network)"
         fi
      fi
   fi
fi
echo -e "\n**************************************************"
echo "  Script ended at $(date)"
echo -e "**************************************************\n"

exit 0
