#!/bin/sh
#####################################################################
#                                                                   #                 
#   Name of the script   : sharedstorage_fom_setup.sh               #
#   Purpose of the script: Setup Failover manager                   #
#   Created on           : 10/25/2012                               #
#   Created by           : Suresh Neravati                          #
#                                                                   #
#####################################################################
#install_dir=`pwd`
sw_dir="/home/oracle/orarac"

# uninstall, install vmware player and VMware server
/usr/bin/vmware-installer -u vmware-player --required > /dev/null 2>&1
/usr/bin/vmware-installer -u vmware-vix --required > /dev/null 2>&1
rm -fR /home/oracle/vmware/FOM > /dev/null 2>&1

export VMWARE_EULAS_AGREED=yes
${sw_dir}/HP_FOM/VMware-Player-5.0.0-812388.x86_64.txt --required
TERM=dumb
VMWARE_EULAS_AGREED=yes
${sw_dir}/HP_FOM/VMware-VIX-1.12.0-812388.x86_64.txt --console --required

/bin/cp /usr/lib/vmware-tools/lib/libXcursor.so.1/libXcursor.so.1 /usr/lib64/libXcursor.so.1
/bin/cp /usr/lib/vmware-tools/lib/libXfixes.so.3/libXfixes.so.3 /usr/lib64/libXfixes.so.3
/bin/cp /usr/lib/vmware-tools/lib/libXinerama.so.1/libXinerama.so.1 /usr/lib64/libXinerama.so.1
/bin/cp /usr/lib/vmware-tools/lib/libXrender.so.1/libXrender.so.1 /usr/lib64/libXrender.so.1

# Convert FOM ovf to vmx format to vmware/FOM directory under oracle home
mkdir -p /home/oracle/vmware/FOM
chown -R oracle:oinstall /home/oracle/vmware
chmod -R 755 /home/oracle/vmware
/usr/bin/ovftool --acceptAllEulas ${sw_dir}/HP_FOM/FOM.ovf /home/oracle/vmware/FOM/FOMconverted.vmx
cp /home/oracle/scripts/rac/clusterware/vmwarefom /home/oracle/vmware/FOM/
chmod -R 755 /home/oracle/vmware/FOM/vmwarefom

cp /etc/vmware/networking /etc/vmware/networking_old >> /dev/null 2>&1
echo -e "
answer VNL_DEFAULT_BRIDGE_VNET -1
add_bridge_mapping tap0 -1
add_bridge_mapping tap1 -1
add_bridge_mapping tap2 -1
add_bridge_mapping tap3 -1
add_bridge_mapping tun1 -1
add_bridge_mapping vboxnet0 -1
add_bridge_mapping vlan10 -1
add_bridge_mapping vlan11 -1
add_bridge_mapping eth4 0" >> /etc/vmware/networking
vmware-networks --stop
vmware-networks --start

exit 0
