#!/bin/sh
export ORACLE_SERVICE=$1
RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
DBCLUSTERNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_CLUSTER_NAME"`

check_db_stat=`ps -ef|grep $ORACLE_SERVICE|grep pmon|wc -l`;
oracle_num=`expr $check_db_stat`
if [ $oracle_num -gt 0 ];
then
   echo "${ORACLE_SERVICE} Database is running...."
sqlplus -s sys\/n2bbsys@"//${DBCLUSTERNAME}:1521/${ORACLE_SERVICE}" as sysdba << END_SQL
        whenever sqlerror exit 1
	alter profile default limit password_life_time unlimited;
	alter profile default limit FAILED_LOGIN_ATTEMPTS unlimited;
	alter profile default limit PASSWORD_LOCK_TIME unlimited;
	alter profile default limit PASSWORD_GRACE_TIME unlimited;
        alter user dbsnmp identified by n2bbsys account unlock;
        alter user sysman identified by n2bbsys account unlock;
END_SQL

else
sqlplus -s sys\/n2bbsys@"//dbcluster-scan:1521/${ORACLE_SERVICE}" as sysdba << ENDSQL1
   startup
   whenever sqlerror exit 1
   alter profile default limit password_life_time unlimited;
   alter profile default limit FAILED_LOGIN_ATTEMPTS unlimited;
   alter profile default limit PASSWORD_LOCK_TIME unlimited;
   alter profile default limit PASSWORD_GRACE_TIME unlimited;
   alter user dbsnmp identified by n2bbsys account unlock;
   alter user sysman identified by n2bbsys account unlock;
ENDSQL1

fi

exit 0

