#!/bin/sh
#--------------------------------------------------------------------------
#  File-name  : rman_backup.sh
#
#  Purpose    : rman full backup - will create full backup of the database.
#
#  Scheduling : This job is scheduled as dbms_scheduler job on the database  
#               and this will run either of the database nodes every Sunday
#               at 2 am.
#--------------------------------------------------------------------------
#
####################### These values can be changed #######################
export retention_days=7
export backup_home=/opt/app/oracle/backup 
RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"` 
NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`
export ORACLE_UNQNAME=ttv
export ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
export ORACLE_BASE=/opt/app/oracle
export ORACLE_HOME=/opt/app/oracle/product/11.2.0/db_1
#export MAIL_LIST="support@ericsson.com"
###########################################################################

#--------------------------------------------------------------------------
#---------------------------- RMAN Function -------------------------------
#--------------------------------------------------------------------------

function run_rman
{

echo "Running RMAN to backup database" 

/opt/app/oracle/product/11.2.0/db_1/bin/rman <<EOF
   connect target /;
RUN{
        configure retention policy to recovery window of $retention_days days;
   }
EOF

/opt/app/oracle/product/11.2.0/db_1/bin/rman <<EOF
   connect target /;
RUN{
        crosscheck archivelog all;
        crosscheck backup;
        delete noprompt expired archivelog all;
        delete noprompt expired backup;
        configure backup optimization on;
        configure controlfile autobackup on;
        configure default device type to DISK;
		configure channel 1 device type disk connect 'sys/n2bbsys@${NODE1_HOSTNAME}:1521/ttv';
		configure channel 2 device type disk connect 'sys/n2bbsys@${NODE2_HOSTNAME}:1521/ttv';
        configure maxsetsize to UNLIMITED;
	    configure device type disk parallelism 2 backup type to compressed backupset;
        backup incremental level 0 database plus archivelog delete input;
        backup filesperset=10 archivelog all delete input;
        delete noprompt obsolete device type DISK;
        delete force noprompt archivelog until time 'sysdate - ${retention_days} ';

	# Call notification routine to indicate job completed successfully
	# sql " BEGIN  DBMS_SCHEDULER.END_DETACHED_JOB_RUN(''sys.rman_fullbackup_job'', 0, null); END; ";

   }
EOF

#------------------------------------------------
#          Delete AUDIT_DUMP_DEST audit files
#------------------------------------------------

/opt/app/oracle/product/11.2.0/db_1/bin/sqlplus -s /nolog <<SQEOF
   connect / as sysdba
   set verify off
   set serveroutput on
   set feedback off
begin
	dbms_output.put_line('Start Deleting Audit Trail OS files...');
	dbms_audit_mgmt.set_last_archive_timestamp(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_OS, last_archive_time => SYSTIMESTAMP - $retention_days,rac_instance_number =>1 );
	dbms_audit_mgmt.clean_audit_trail(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_OS);
	if not(dbms_audit_mgmt.is_cleanup_initialized(audit_trail_type => dbms_audit_mgmt.audit_trail_aud_std)) then
		dbms_audit_mgmt.init_cleanup(audit_trail_type => dbms_audit_mgmt.audit_trail_aud_std, default_cleanup_interval => 12 );
	end if;
	dbms_audit_mgmt.set_last_archive_timestamp(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_AUD_STD, last_archive_time => SYSTIMESTAMP - $retention_days,rac_instance_number =>1 );
	dbms_audit_mgmt.clean_audit_trail(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_AUD_STD);

	dbms_audit_mgmt.set_last_archive_timestamp(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_OS, last_archive_time => SYSTIMESTAMP - $retention_days,rac_instance_number =>2 );
	dbms_audit_mgmt.clean_audit_trail(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_OS);
	if not(dbms_audit_mgmt.is_cleanup_initialized(audit_trail_type => dbms_audit_mgmt.audit_trail_aud_std)) then
		dbms_audit_mgmt.init_cleanup(audit_trail_type => dbms_audit_mgmt.audit_trail_aud_std, default_cleanup_interval => 12 );
	end if;
	dbms_audit_mgmt.set_last_archive_timestamp(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_AUD_STD, last_archive_time => SYSTIMESTAMP - $retention_days,rac_instance_number =>2 );
	dbms_audit_mgmt.clean_audit_trail(audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_AUD_STD);
	dbms_output.put_line('Finished Deleting Audit Trail OS files!');
end;
/
exit
SQEOF

#------------------------------------------------
#          Delete BACKGROUND DUMP trace files
#------------------------------------------------

tot_mins=`expr $retention_days \\* 1440`
dbhome=`/opt/app/oracle/product/11.2.0/db_1/bin/adrci EXEC="SHOW HOMES" |grep -v "ADR Homes:"` 
for db_inst in ${dbhome[@]}
do
 /opt/app/oracle/product/11.2.0/db_1/bin/adrci EXEC="SET HOME $db_inst; purge -age $tot_mins" 
done

} #END run_rman

#--------------------------------------------------------------------------
#---------------------------- RMAN execution ------------------------------
#--------------------------------------------------------------------------

run_rman

#--------------------------------------------------------------------------
# End of file

