#!/bin/sh
#--------------------------------------------------------------------------
#  File-name  : rman_backup_arch.sh
#
#  Purpose    : rman arch backup - will create archive log backup of the 
#               database.
#
#  Scheduling : This job is scheduled as dbms_scheduler job on the database  
#               and this will run either of the database nodes every 4 hrs.
#--------------------------------------------------------------------------
#
####################### These values can be changed #######################

export retention_days=7

export backup_home=/opt/app/oracle/backup 

export ORACLE_UNQNAME=ttv

export ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`

export ORACLE_BASE=/opt/app/oracle

export ORACLE_HOME=/opt/app/oracle/product/11.2.0/db_1

#export MAIL_LIST="support@ericsson.com"

###########################################################################

#--------------------------------------------------------------------------
#---------------------------- RMAN Function -------------------------------
#--------------------------------------------------------------------------

function run_rman_arch
{

echo "Running RMAN to backup database archivelogs" 

/opt/app/oracle/product/11.2.0/db_1/bin/rman <<EOF
   connect target /;
RUN{
    crosscheck archivelog all;
    delete noprompt expired archivelog all;
    backup filesperset=10 archivelog all delete input skip inaccessible;

   }
EOF

} #END run_rman_arch


#--------------------------------------------------------------------------
#---------------------------- RMAN execution ------------------------------
#--------------------------------------------------------------------------

run_rman_arch

#--------------------------------------------------------------------------
# End of file
