#####################################################################
##        Script Name  : setup_shared_storage.sh                   ##
##        Version #    : 1.0                                       ##
##        create Date  : 21-Aug-2012                               ##
##        Created by   : Suresh Neravati                           ##
##        Usage        : sh install_ora_binaries.sh                ##
#####################################################################
#!/bin/sh
install_dir="/home/oracle/scripts/rac/installoracle"
install_ora_log="ora_binary_install.log"
RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"`
NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`
RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
ORA_HOME="/opt/app/oracle/product/11.2.0/db_1"
sw_dir="/home/oracle/orarac"
CURRENTHOST=`hostname`
if [ `whoami` !=  "root" ]; then
   echo "You can run this script as root user only, Please try again ....!"
   exit 1
fi

echo -e "\n**************************************************************"
echo "     Script started at $(date)"
echo -e "**************************************************************\n"
vcrs=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_CLUSTER_CRS_VOLUME"`
vdata=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_CLUSTER_DATA_VOLUME"`
vfra=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_CLUSTER_FRA_VOLUME"`

#echo -e "CRS_VOLUME=${vcrs} \nDATA_VOLUMNE=${vdata} \nFRA_VOLUME=${vfra}"
if [ "${vcrs}" == "" ] || [ "${vdata}" == "" ] || [ "${vfra}" == "" ]; then
   echo "Configuration file is missing crs or data or fra volume names. Please define these names and run the script again...!"
   exit 1
fi
echo -e "\nAdding Disk Groups, Please wait .....!\n"
su - oracle -c "/opt/app/11.2.0/grid/bin/asmca -silent -createDiskGroup -diskGroupName DATA -disk /dev/iscsi/oraasm-datap1 -redundancy EXTERNAL -sysAsmPassword n2bbsys"
su - oracle -c "/opt/app/11.2.0/grid/bin/asmca -silent -createDiskGroup -diskGroupName FRA -disk /dev/iscsi/oraasm-frap1 -redundancy EXTERNAL -sysAsmPassword n2bbsys"
su - oracle -c "/opt/app/11.2.0/grid/bin/asmca -silent -createDiskGroup -diskGroupName CLUSFILES -disk /dev/iscsi/oraasm-clusfilesp1 -redundancy EXTERNAL -sysAsmPassword n2bbsys"
su - oracle -c "/opt/app/11.2.0/grid/bin/asmca -silent -postConfigureASM -oui_internal -sysAsmPassword n2bbsys -asmMonitorPassword n2bbsys"

if [ "${NODE1_HOSTNAME}" == "" ] || [ "${NODE2_HOSTNAME}" == "" ] || [ "${CURRENTHOST}" == "" ]; then
   echo -e "\nPlease check rac_setup.conf file for missing values of node hostnames. Try again....!"
   exit 1
else
   sed -e "s/CURRENTHOST/${CURRENTHOST}/g" -e "s/NODE1/${NODE1_HOSTNAME}/g" -e "s/NODE2/${NODE2_HOSTNAME}/g" -e "s/PUBLIC_NW_SERIES/${PUBLIC_NWSERIES}/g" -e "s/PRIVATE_NW_SERIES/${PRIVATE_NWSERIES}/g" < ${install_dir}/db_template.rsp > ${install_dir}/db.rsp
fi

if [ -f ${install_dir}/db.rsp ]; then
   echo -e "\nPlease wait until the Oracle installation completes.....!\n"
   su - oracle -c "export ORACLE_HOME=${ORA_HOME}; /home/oracle/orarac/database/runInstaller -responseFile ${install_dir}/db.rsp -silent -ignorePrereq -showProgress -waitforcompletion 2>&1 | tee ${install_dir}/${install_ora_log}"
   mv ${install_dir}/db.rsp ${install_dir}/db_old.rsp 
   if [ ! -f ${install_dir}/${install_ora_log} ]
   then
      echo "**************************************************************************************"
      echo " Oracle script probably failed!  ${install_dir}/${install_ora_log} file is not exists..!"
      echo "**************************************************************************************"
      exit 1
   else
      if  grep -q "ORA-\|Permission denied\|FATAL" "${install_dir}/${install_ora_log}"
      then
         echo "**************************************************************************************"
         echo " Oracle installation probably failed! Check ${INSTALL_DIR}/${install_ora_log} file for details."
         echo "**************************************************************************************"
         exit 1
      else
         if  grep -q "Successfully Setup Software." "${install_dir}/${install_ora_log}"
         then
            echo -e "\n**************************************************************************************\n"
            echo -e "\nRunning the above root.sh scripts to complete the oracle binary installation.\n"
            ssh "root@${NODE1_HOSTNAME}" "sh ${ORA_HOME}/root.sh"
            ssh "root@${NODE2_HOSTNAME}" "sh ${ORA_HOME}/root.sh"
            echo -e "\n**************************************************************************************\n"
            echo -e "\nApplying Oracle database patches on both nodes, please wait......\n"
            ssh "root@${NODE1_HOSTNAME}" "rm -rf ${ORA_HOME}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${ORA_HOME};chown -R oracle:oinstall ${ORA_HOME}/OPatch"
            ssh "root@${NODE2_HOSTNAME}" "rm -rf ${ORA_HOME}/OPatch;cp -rf ${sw_dir}/opatch/OPatch ${ORA_HOME};chown -R oracle:oinstall ${ORA_HOME}/OPatch"
            ssh "root@${NODE1_HOSTNAME}" "${ORA_HOME}/OPatch/opatch auto ${sw_dir}/opatch/16083653 -ocmrf ${install_dir}/db_ocm.rsp"
            ssh "root@${NODE2_HOSTNAME}" "${ORA_HOME}/OPatch/opatch auto ${sw_dir}/opatch/16083653 -ocmrf ${install_dir}/db_ocm.rsp"
            ssh "oracle@${CURRENTHOST}" "cd ${sw_dir}/opatch/13511618; ${ORA_HOME}/OPatch/opatch apply -silent -ocmrf ${install_dir}/db_ocm.rsp"
            ssh "oracle@${CURRENTHOST}" "cd ${sw_dir}/opatch/13768231; ${ORA_HOME}/OPatch/opatch apply -silent -ocmrf ${install_dir}/db_ocm.rsp"
            ssh "oracle@${CURRENTHOST}" "cd ${sw_dir}/opatch/13779466; ${ORA_HOME}/OPatch/opatch apply -silent -ocmrf ${install_dir}/db_ocm.rsp"
         fi
      fi
   fi
fi
echo -e "\n**************************************************"
echo "  Script ended at $(date)"
echo -e "**************************************************\n"

exit 0
