#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/alert_log_file_size_analyzer.sh /st_has_11.2.0/1 2011/04/27 13:09:42 nvira Exp $
#
# alert_log_file_size_analyzer.sh
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      alert_log_file_size_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       10/05/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin

SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

# Set default exit message to indicate failure.
 result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking the size of alert log file</EXEC_ERROR><TRACE>Error while checking the size of alert log file</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2894</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"
exitstatus=0
dbName=$1
expectedSize=$2
analyzerFileList=$3

expectedCount=0
count=0

analyzerPath=`$SGREP PATH $analyzerFileList | $SAWK -F= '{print \$2}'`
analyzerFileName=`$SGREP GLOBAL $analyzerFileList | $SAWK -F= '{print \$2}'`
analyzerFile=$analyzerPath/$analyzerFileName


echo "<RESULTSET>"

while read LINE
do
  if [ "x$LINE" != "x" ]
  then
    alert_dest=`echo "$LINE" | $SAWK '{print $2}'`
    instance_id=`echo "$LINE" | $SAWK '{print $1}'`
    instance_id=${dbName}"("${instance_id}")"
    tempCount=0
    count=`find $alert_dest -name 'alert*.log' -size +$expectedSize 2>/dev/null|wc -l`
    ret=$?

    if [ $ret -eq 0 ]
    then
      if [ $count -le $expectedCount ]
        then
          echo "<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>Alert log is not too big</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2892</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      else
          echo "<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>Alert log file is too big and should be rolled over periodically</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2893</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      fi   
    else
      echo "<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking for ORA-00600 errors in alert log</EXEC_ERROR><TRACE>Error while checking the size of alert log file</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2894</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
    fi   
  fi
done <$analyzerFile

echo "</RESULTSET>"

exit $exitstatus
