#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/bdump_dest_trace_analyzer.sh /st_has_11.2.0/1 2011/04/27 13:09:42 nvira Exp $
#
# bdump_dest_trace_analyzer.sh
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      bdump_dest_trace_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       10/06/10 - external analyzer to verify old trace files in
#                           bdump_dest
#    nvira       10/06/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin

SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking background dump destination</EXEC_ERROR><TRACE>Error while checking background dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2914</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"
exitstatus=0
dbName=$1
ageInDays=$2
expectedCount=$3
analyzerFileList=$4

analyzerPath=`$SGREP PATH $analyzerFileList | $SAWK -F= '{print \$2}'`
analyzerFileName=`$SGREP GLOBAL $analyzerFileList | $SAWK -F= '{print \$2}'`

analyzerFile=$analyzerPath/$analyzerFileName


echo "<RESULTSET>"

while read LINE
do
  if [ "x$LINE" != "x" ]
  then
    bdump_dest=`echo "$LINE" | $SAWK '{print $2}'`
    instance_id=`echo "$LINE" | $SAWK '{print $1}'`
    instance_id=${dbName}"("${instance_id}")"
    tempCount=0
    count=`find $bdump_dest -name '*.trc' -mtime +$ageInDays 2>/dev/null |wc -l`
    ret=$?

    if [ $ret -eq 0 ]
    then
      if [ $count -le $expectedCount ]
        then
          echo "<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>background_dump_dest does not have too many old background dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2912</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      else
          echo "<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>background_dump_dest has too many old background dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2913</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      fi   
    else
      echo "<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking background dump destination</EXEC_ERROR><TRACE>Error while checking background dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2914</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
    fi   
  fi
done <$analyzerFile

echo "</RESULTSET>"

exit $exitstatus

