#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/check_jumbo_frames.sh /st_has_11.2.0/1 2011/04/27 13:09:42 nvira Exp $
#
# check_jumbo_frames.sh
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      check_jumbo_frames.sh - Jumbo frames configuration for interconnect
#
#    DESCRIPTION
#      Script to check jumbo frames configuration for interconnect
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       08/25/10 - pluggable task script to check jumbo frame settings
#    nvira       08/25/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin

SGREP="grep"
SAWK="awk"
SCUT="cut"
SNETSTAT="netstat"
SUNIQ="uniq"
STAIL="tail"


PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac
CRS_HOME=$1

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while Jumbo Frames setting information on the system</EXEC_ERROR><TRACE>Unable to get the Jumbo Frames setting information on the system</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0234</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
exitstatus=0
expected=$2

ci=`$CRS_HOME/bin/oifcfg getif| $SGREP cluster_interconnect | $STAIL -1 | $SAWK '{print \$1}'`

case $PLATFORM in
  Linux)
      mtu=`/sbin/ifconfig $ci | $SGREP -i mtu| $SCUT -d: -f2| $SAWK '{print \$1}'`
      ret=$?
  ;;
  SunOS | HP-UX)
      mtu=`/sbin/ifconfig $ci | $SGREP -i mtu | $SAWK '{print \$4}'`
      ret=$?
  ;;
  AIX)
      mtu=`$SNETSTAT -i| $SGREP $ci | $SAWK '{print \$2}'| $SUNIQ`
      ret=$?
  ;;
esac

if [ $ret -eq 0 ]
then
  if [ $mtu -ge $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$mtu</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>Jumbo frames or mini jumbo frames are configured for interconnect on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0232</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$mtu</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>Jumbo frames are not configured for interconnect on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0233</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  fi   
else
  result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while Jumbo Frames information on the system</EXEC_ERROR><TRACE>Unable to get the Jumbo Frames setting information on the system</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0234</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
fi   


echo $result
exit $exitstatus
