#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/check_network_param.sh /st_has_11.2.0/3 2011/08/25 21:39:16 nvira Exp $
#
# check_available.sh
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      check_network_param.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       08/18/11 - bug fix 12878750
#    nvira       07/19/11 - Backport nvira_bug-12536867 from main
#    nvira       08/25/10 - script to check network parameter
#    nvira       08/11/10 - Creation
#

#returns list of all interfaces
listOfInterfaces()
{
  INTERFACE_LIST=`netstat -i | $SSED '1d' | cut -d ' ' -f 1 | sort -u`
  #echo "INTERFACE_LIST=$INTERFACE_LIST"
}

#expand list of interfaces for any wildcard characters 
expandInterfaces()
{
  ARG=$1
  EXPANDED_LIST=`echo $INTERFACE_LIST| $SAWK '{gsub(" ","\n", $0); print}' | $SSED "s/$/ $ARG/" | $SAWK '{if ($1 ~ $2) print $1 }'`
}

verifyInterface()
{
interfaceName=$1
#first check if there is any interface specific value defined for the parameter
paramValue=`/etc/ifconfig $interfaceName | $SGREP $paramName | $SSED "s/\(.*\)$paramName \([0-9]*\)\(.*\)/\2/"`

if [ "X$paramValue" != "X" ]
then
  if [ $paramValue -eq $expected ]
  then 
    ERROR_CODE=0
  else
    ERROR_CODE=2
  fi   
  return $ERROR_CODE
fi

#else check the global value defined for the parameter
paramValue=`$NO -o $paramName | $SAWK '{print $3}'`

ret=$?

if [ $ret -eq 0 ]
then
  if [ $paramValue -eq $expected ]
  then 
    ERROR_CODE=0
  else
    ERROR_CODE=3
  fi   
else
  ERROR_CODE=4
fi   
return $ERROR_CODE
}


PLATFORM=`/bin/uname`

SAWK="/bin/awk"
SGREP="/bin/grep"
SSED="/bin/sed"
NO="/etc/no"

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac


# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while retrieving network parameter information on the system</EXEC_ERROR><TRACE>Unable to get the network parameter information on the system</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0274</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
exitstatus=3
expected=$3
paramName=$2
stage=$1

listOfInterfaces


if [ $stage = "-pre" ]
then 
  # the interface list is passed in the form "eth0:130.35.64.0:PUB,eth1:139.185.44.0:PVT", parse the first private interconnect
  interfaceTuple=$4
  interfaceNames=`echo $interfaceTuple |  $SAWK '{gsub(",","\n", $0); print}' | $SSED -n -e '/:PVT/p' -e '/:cluster_interconnect/p' |  $SSED -e 's/\([^:]*\):\([^:]*\):PVT/\1/' -e 's/\([^:]*\):\([^:]*\):cluster_interconnect/\1/' | $SSED 's/"//g'`
else
  #in case of -post, the fourth paramter is the crs home
  CRS_HOME=$4
  interfaceNames=`$CRS_HOME/bin/oifcfg getif| $SGREP cluster_interconnect | $SAWK '{print \$1}'`
fi

#strip off any new line characters
interfaceNames=`echo $interfaceNames`

expandedList=""
for interfaceName in $interfaceNames; do
	expandInterfaces "$interfaceName"
    expandedList=`echo "$expandedList $EXPANDED_LIST"`
done

expandedList=`echo $expandedList |  $SAWK '{gsub("\n"," ", $0); print}'`


FAILED_INTERFACES=""
FAILED_COLLECTED=""

for interfaceName in $expandedList; do
 verifyInterface "$interfaceName"
 ret=$?
 if [ "X$COLLECTED" != "X" ]
 then
  COLLECTED=`echo "$COLLECTED;"`
 fi
 COLLECTED=`echo "$COLLECTED$interfaceName=$paramValue"`
 if [ ret -ne 0 ]
 then
   if [ "X$FAILED_INTERFACES" != "X" ]
   then
    FAILED_INTERFACES=`echo "$FAILED_INTERFACES,"`
    FAILED_COLLECTED=`echo "$FAILED_COLLECTED;"`
   fi
   FAILED_INTERFACES=`echo "$FAILED_INTERFACES$interfaceName"`
   FAILED_COLLECTED=`echo "$FAILED_COLLECTED$interfaceName=$paramValue"`
 fi
done

if [ "X$FAILED_INTERFACES" = "X" ]
then
    result="<RESULT>SUCC</RESULT><COLLECTED>$COLLECTED</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>The value of network parameter $paramName is set to the expected value $expected on node $_HOST.</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0272</ID><MSG_DATA><DATA>$paramName</DATA><DATA>$expected</DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$FAILED_COLLECTED</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>The value of network parameter $paramName, for interfaces \"$FAILED_INTERFACES\", is not configured to the expected value on node $_HOST.[Expected=$expected; Found=$FAILED_COLLECTED]</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0273</ID><MSG_DATA><DATA>$paramName</DATA><DATA>$_HOST</DATA><DATA>$expected</DATA><DATA>$FAILED_COLLECTED</DATA><DATA>$FAILED_INTERFACES</DATA></MSG_DATA></NLS_MSG>"
fi

echo $result
exit $exitstatus

