#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/css_misscount.sh /st_has_11.2.0/3 2011/09/21 18:06:56 agorla Exp $
#
# css_misscount.sh
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      css_misscount.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    agorla      09/21/11 - bug#13002015 - fix
#    nvira       08/05/11 - bug fix 12837371
#    nvira       08/11/10 - pluggable script to check css misscount settings
#    nvira       08/09/10 - pluggable script for css misscount
#    nvira       08/09/10 - Creation
#

SCAT="/bin/cat"
SGREP="/bin/grep"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
esac

existstatus=3
CRS_HOME=$1
expected=$2

#determine presence of vendor clusterware on SunOS or HP-UX
vcluster=1 #holds zero if vendor cluster is present
if [ $PLATFORM = SunOS ]
then
  if  [ -f /opt/ORCLcluster/lib/libskgxn2.so ]
  then
    vcluster=0
  fi 
elif [ $PLATFORM = HP-UX ]
then
  if  [ -f /opt/nmapi/nmapi2/lib/hpux64/libnmapi2.so ]
  then
    vcluster=0
  fi 
fi

if [ $vcluster -eq 0 ]
then
  expected=600
fi

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXPECTED>$expected</EXPECTED><EXEC_ERROR>Error while CSS misscount settings</EXEC_ERROR><TRACE>Unable to get the CSS misscount settings on the sytem</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0254</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"


css_misscount=`$CRS_HOME/bin/crsctl get css misscount`
ret=$?

if [ $ret -eq 0 ]
then
  css_misscount=`echo "$css_misscount" | sed 's/CRS-4678:\([^0-9]*\)\([0-9]*\)\(.*\)/\2/'`

  if [ $css_misscount -ge $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$css_misscount</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is set to recommended value of $expected or more on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0252</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$css_misscount</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is not set to recommended value of $expected or more on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0253</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>VFAIL</RESULT><COLLECTED>NOT SET</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0253</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  existstatus=2
fi   

echo $result
exit $existstatus
