/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.Iterator;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.variableinstance.NullInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.context.log.VariableCreateLog;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public abstract class VariableInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected Token token = null;
    protected TokenVariableMap tokenVariableMap = null;
    protected ProcessInstance processInstance = null;
    protected Converter converter = null;
    protected Object valueCache = null;
    protected boolean isValueCached = false;

    public static VariableInstance create(Token token, String name, Object value) {
        VariableInstance variableInstance = null;
        variableInstance = value == null ? new NullInstance() : VariableInstance.createVariableInstance(value);
        variableInstance.token = token;
        variableInstance.name = name;
        ProcessInstance processInstance = variableInstance.processInstance = token != null ? token.getProcessInstance() : null;
        if (token != null) {
            token.addLog(new VariableCreateLog(variableInstance));
        }
        variableInstance.setValue(value);
        return variableInstance;
    }

    public static VariableInstance createVariableInstance(Object value) {
        VariableInstance variableInstance = null;
        Iterator iter = JbpmType.getJbpmTypes().iterator();
        while (iter.hasNext() && variableInstance == null) {
            JbpmType jbpmType = (JbpmType)iter.next();
            if (!jbpmType.matches(value.getClass())) continue;
            variableInstance = jbpmType.newVariableInstance();
        }
        if (variableInstance == null) {
            variableInstance = new UnpersistableInstance();
        }
        return variableInstance;
    }

    public abstract boolean isStorable(Object var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public boolean supports(Object value) {
        if (this.converter != null) {
            return this.converter.supports(value);
        }
        return this.isStorable(value);
    }

    public void setValue(Object value) {
        this.valueCache = value;
        this.isValueCached = true;
        if (this.converter != null) {
            if (!this.converter.supports(value)) {
                throw new JbpmException("the converter '" + this.converter.getClass().getName() + "' in variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
            }
            value = this.converter.convert(value);
        }
        if (value != null && !this.isStorable(value)) {
            throw new JbpmException("variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
        }
        this.setObject(value);
    }

    public Object getValue() {
        if (this.isValueCached) {
            return this.valueCache;
        }
        Object value = this.getObject();
        if (value != null && this.converter != null) {
            this.valueCache = value = this.converter.revert(value);
            this.isValueCached = true;
        }
        return value;
    }

    public void removeReferences() {
        this.tokenVariableMap = null;
        this.token = null;
        this.processInstance = null;
    }

    public String toString() {
        return "${" + this.name + "}";
    }

    public String getName() {
        return this.name;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setTokenVariableMap(TokenVariableMap tokenVariableMap) {
        this.tokenVariableMap = tokenVariableMap;
    }
}

