/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.series;

import com.ericsson.cms.criteria.ExpList;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SeriesIdentifier
extends IdentifierBase {
    private static final long serialVersionUID = -8112844616094249184L;
    private static String ID = "SERIES_IDENTIFIER";
    private String id;

    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ID, this.id);
        return map;
    }

    public Map<String, String> getTTVPaths() {
        HashMap<String, String> paths = new HashMap<String, String>();
        String seriesIndentifierXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)ID);
        if (seriesIndentifierXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + ID + " cannot be mapped to TTV xpath.");
        }
        paths.put(ID, seriesIndentifierXpath);
        return paths;
    }

    public boolean isValidIdentifier() {
        return this.id != null && !this.id.equals("");
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(ID)) {
            this.setId(identifiers.get(ID));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeriesIdentifier)) {
            return false;
        }
        SeriesIdentifier another = (SeriesIdentifier)((Object)o);
        return this.isEqual(this.id, another.id);
    }

    private boolean isEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public int hashCode() {
        int h1 = this.id != null ? this.id.hashCode() : 0;
        return (h1 + 7) * 13;
    }

    public String toString() {
        return this.id;
    }

    protected ExpList buildSearchFields(SearchCriteria criteriaMap) {
        return new SearchFieldBuilder().getAssetSearchFields(criteriaMap, "Series");
    }
}

