/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.template;

import com.ericsson.cms.sites.core.entities.DistributionOption;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigReader {
    private static String SITE_PROPERTIES = "/sync-sites-actions/site_sync.properties";
    private static String DISTRIBUTION_OPTION = "distributionOption";
    private static String DISTRIBUTION_SITE_ALERT_DELAY_PERIOD = "distributionSiteAlertDelayPeriod";
    private static String TRACKING_SITE_ALERT_DELAY_PERIOD = "trackingSiteAlertDelayPeriod";
    private static String TEMPLATE_NAME = "distTemplateName";
    private static Properties config = new Properties();
    private InputStream stream = this.getClass().getResourceAsStream(SITE_PROPERTIES);
    private static final Logger logger = Logger.getLogger(ConfigReader.class);
    private static ConfigReader _instance;

    public static synchronized ConfigReader getInstance() {
        if (_instance == null) {
            _instance = new ConfigReader();
        }
        return _instance;
    }

    public DistributionOption getDistributionOption() {
        DistributionOption distOption = DistributionOption.IMMEDIATE;
        try {
            config.load(this.stream);
            distOption = DistributionOption.valueOf((String)config.getProperty(DISTRIBUTION_OPTION).trim());
        }
        catch (Exception e) {
            logger.debug((Object)"Error while reading distribution option: ", (Throwable)e);
        }
        return distOption;
    }

    public Integer getDistributionSiteAlertDelayPeriod() {
        Integer delay = 60;
        try {
            config.load(this.stream);
            delay = Integer.valueOf(config.getProperty(DISTRIBUTION_SITE_ALERT_DELAY_PERIOD).trim());
        }
        catch (Exception e) {
            logger.debug((Object)"Error while reading distribution site alert delay period: ", (Throwable)e);
        }
        return delay;
    }

    public Integer getTrackingSiteAlertDelayPeriod() {
        Integer delay = 60;
        try {
            config.load(this.stream);
            delay = Integer.valueOf(config.getProperty(TRACKING_SITE_ALERT_DELAY_PERIOD).trim());
        }
        catch (Exception e) {
            logger.debug((Object)"Error while reading tracking site alert delay period: ", (Throwable)e);
        }
        return delay;
    }

    public String getTemplateName() {
        String templateName = "";
        try {
            config.load(this.stream);
            templateName = config.getProperty(TEMPLATE_NAME).trim();
        }
        catch (Exception e) {
            logger.debug((Object)"Error while reading template name: ", (Throwable)e);
        }
        return templateName;
    }
}

