/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.template;

import com.ericsson.cms.devices.template.ConfigReader;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SyncronizeSites
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SyncronizeSites.class);
    public static final String CATCHER_GROUP_ID = "catcherGroupId";
    public static final String CATCHER_GROUP_NAME = "catcherGroupName";
    public static final String CATCHER_IDS = "catcherIds";
    public static final String CATCHER_NAMES = "catcherNames";
    private String catcherGroupId;
    private String catcherGroupName;
    private List<String> catcherIds;
    private List<String> catcherNames;
    private static final Object tslock = new Object();

    @Transactional
    public void execute(ExecutionContext context) throws Exception {
        ExecutionContext executionContext = context;
        SyncronizeSites.execute_aroundBody1$advice(this, executionContext, TransactionEnforcer.aspectOf(), SyncronizeSites.class.getDeclaredMethod("execute", ExecutionContext.class).getAnnotation(Transactional.class), null);
    }

    private void inactivateMediapathDistributionSite(final MediapathDistributionSite mds) {
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                if (mds.getDistributionOption() == DistributionOption.TIMED) {
                    String q1 = "update sch_job j  set active = 0  where j.id in ( select j.id from sch_job j, sch_associated_entities entity, sites_site site  where j.associated_entity_type = 'sitetimer'  and entity.job_id = j.id  and site.id_ = " + mds.getId() + " and entity.entity_id = site.id_)";
                    PreparedStatement statement = conn.prepareStatement(q1);
                    statement.executeQuery();
                }
                IScheduler scheduler = SyncronizeSites.this.getScheduler();
                List jobs = scheduler.getJobsByAssociatedEntity("Sites", (long)mds.getId().intValue());
                for (Job j : jobs) {
                    if (j.getAssociatedEntities().size() > 1) {
                        scheduler.dissociate(j.getId().longValue(), (long)mds.getId().intValue());
                        continue;
                    }
                    if (!j.isActive()) continue;
                    scheduler.setActive(j.getId().longValue(), false);
                }
                String ruleIdQuery = "select e.ENTITY_ID from sch_job j, sch_associated_entities e, sites_site_ruleset r  where j.ASSOCIATED_ENTITY_TYPE = 'ruleset'  and e.JOB_ID = j.ID  and e.ENTITY_ID = r.RULESETID  and r.SITEID = " + mds.getId();
                PreparedStatement statement = conn.prepareStatement(ruleIdQuery);
                ResultSet results = statement.executeQuery(ruleIdQuery);
                IRuleManager ruleManager = SyncronizeSites.this.getRuleManager();
                while (results.next()) {
                    int rulesetId = results.getInt(1);
                    TreRuleSet ruleSet = ruleManager.getRuleSet(rulesetId);
                    if (ruleSet.getSites().size() > 1) {
                        ruleSet.getSites().remove(mds);
                        continue;
                    }
                    ArrayList<Integer> rulesetIds = new ArrayList<Integer>();
                    rulesetIds.add(rulesetId);
                    ruleManager.setRuleSetsEnabled(rulesetIds, false);
                }
                String q2 = "update sites_site set active = 0 where id_ = " + mds.getId();
                statement = conn.prepareStatement(q2);
                statement.executeQuery();
            }
        };
        this.doWork(work);
    }

    private MediapathDistributionSite syncMediaPathSite(MediapathDistributionSite mds, List<String> catcherIds) {
        Set tsSites = mds.getChildren();
        ArrayList<TrackingSite> tobeRemoved = new ArrayList<TrackingSite>();
        for (TrackingSite ts : tsSites) {
            if (this.find(ts, catcherIds)) continue;
            tobeRemoved.add(ts);
        }
        for (TrackingSite ts : tobeRemoved) {
            if (ts.getParents().size() > 1) {
                this.dissociateTrackingSite(ts, mds);
                continue;
            }
            this.deleteDedicatedTrackingSite(ts.getId(), mds.getId());
        }
        for (int i = 0; i < catcherIds.size(); ++i) {
            if (this.find(catcherIds.get(i), mds)) continue;
            this.addTrackingSite(mds, catcherIds.get(i), i);
        }
        return mds;
    }

    private void deleteDedicatedTrackingSite(final Integer tsId, final Integer mdsId) {
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                String q1 = SyncronizeSites.this.getQueryForDeletingTrackingSiteTitles(tsId, mdsId);
                PreparedStatement statement = conn.prepareStatement(q1);
                statement.executeQuery();
                String q2 = SyncronizeSites.this.getQueryForDeletingAssociation(tsId, mdsId);
                statement = conn.prepareStatement(q2);
                statement.executeQuery();
                String q3 = "delete from sites_site where id_ = " + tsId;
                statement = conn.prepareStatement(q3);
                statement.executeQuery();
            }
        };
        this.doWork(work);
    }

    private void dissociateTrackingSite(final TrackingSite ts, final MediapathDistributionSite mds) {
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                String q1 = SyncronizeSites.this.getQueryForDeletingTrackingSiteTitles(ts.getId(), mds.getId());
                PreparedStatement statement = conn.prepareStatement(q1);
                statement.executeQuery();
                String q2 = SyncronizeSites.this.getQueryForDeletingAssociation(ts.getId(), mds.getId());
                statement = conn.prepareStatement(q2);
                statement.executeQuery();
            }
        };
        this.doWork(work);
    }

    private String getQueryForDeletingTrackingSiteTitles(Integer tsId, Integer mdsId) {
        return "delete from sites_tracksitetitle t  where t.ROWID in (select t.rowid from sites_tracksitetitle t, sites_distsitetitle d, sites_sitelink sl  where t.siteid = " + tsId + " and t.titleid = d.TITLEID " + " and sl.child = " + tsId + " and sl.parent = d.SITEID " + " and d.siteid = " + mdsId + ")";
    }

    private String getQueryForDeletingAssociation(Integer tsId, Integer mdsId) {
        return "delete from sites_sitelink where child = " + tsId + " and parent = " + mdsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTrackingSite(MediapathDistributionSite mds, String catcherId, int index) {
        Object object = tslock;
        synchronized (object) {
            List existingSites = this.getSiteManager().getSitesByExternalId(catcherId);
            if (existingSites != null && existingSites.size() > 0) {
                Site s = (Site)existingSites.get(0);
                if (s.getType() != SiteType.TRACKING) throw new RuntimeException("There is another distribution or logical site with this externalid: " + catcherId);
                ((TrackingSite)s).addParent((DistributionSite)mds);
            } else {
                ConfigReader reader = ConfigReader.getInstance();
                TrackingSite ts = new TrackingSite();
                ts.setActive(true);
                ts.setAlertDelayPeriod(reader.getTrackingSiteAlertDelayPeriod());
                ts.setExternalId(catcherId);
                ts.setName(this.catcherNames.get(index));
                ts.addParent((DistributionSite)mds);
                this.getSiteManager().createTrackingSite(ts, mds.getId());
            }
            return;
        }
    }

    private boolean find(TrackingSite ts, List<String> catcherIds) {
        for (String id : catcherIds) {
            if (!ts.getExternalId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private boolean find(String id, MediapathDistributionSite mds) {
        if (mds.getChildren() == null || mds.getChildren().isEmpty()) {
            return false;
        }
        final String q = "select count(*) from sites_sitelink sl, sites_site s  where sl.parent = " + mds.getId() + " and s.externalid = '" + id + "'" + " and s.type = 3 " + " and s.id_ = sl.child";
        final StringBuffer cnt = new StringBuffer();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(q);
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    cnt.append(results.getInt(1));
                }
            }
        };
        this.doWork(work);
        return cnt.length() > 0 && cnt.toString().equals("1");
    }

    private void doWork(Work work) {
        Session session = HibernateContext.getContext().getSessionFactory().openSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                logger.error((Object)"Error while cancelling query: ", (Throwable)e);
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    protected org.hibernate.Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private MediapathDistributionSite createMediaPathSite(String catcherGroupName, String dsExternalId, List<String> trackingSiteExternalIds) {
        MediapathDistributionSite mds = new MediapathDistributionSite();
        ConfigReader reader = ConfigReader.getInstance();
        mds.setActive(false);
        mds.setMetadataFormat("CableLabsVOD1.1");
        mds.setAlertDelayPeriod(reader.getDistributionSiteAlertDelayPeriod());
        mds.setDistributionOption(reader.getDistributionOption());
        if (mds.getDistributionOption() == DistributionOption.TIMED) {
            Job timerJob = new Job();
            ScheduleRule schedule = new ScheduleRule();
            schedule.setType(ScheduleRuleType.EVERY_N_DAYS);
            ArrayList<ScheduleRuleParameter> params = new ArrayList<ScheduleRuleParameter>();
            ScheduleRuleParameter numberOfDaysParam = new ScheduleRuleParameter();
            numberOfDaysParam.setOrder(1);
            numberOfDaysParam.setValue("1");
            numberOfDaysParam.setRule(schedule);
            params.add(numberOfDaysParam);
            ScheduleRuleParameter timeParam = new ScheduleRuleParameter();
            timeParam.setOrder(2);
            timeParam.setRule(schedule);
            timeParam.setValue("12:00 am");
            params.add(timeParam);
            schedule.setParams(params);
            timerJob.setRule(schedule);
            mds.setTimerJob(timerJob);
        }
        mds.setDistTemplateName(reader.getTemplateName());
        mds.setExternalId(dsExternalId);
        mds.setName(catcherGroupName);
        this.getSiteManager().createDistributionSite((DistributionSite)mds, null);
        for (int i = 0; i < trackingSiteExternalIds.size(); ++i) {
            this.addTrackingSite(mds, trackingSiteExternalIds.get(i), i);
        }
        return mds;
    }

    private MediapathDistributionSite findMediaPathDistributionSite(String externalId) {
        ISiteManager siteManager = this.getSiteManager();
        List mdsList = siteManager.getSitesByExternalId(externalId);
        if (mdsList.isEmpty()) {
            return null;
        }
        Site ds = (Site)mdsList.get(0);
        if (ds.getType() == SiteType.DISTRIBUTION && ds instanceof MediapathDistributionSite) {
            return (MediapathDistributionSite)ds;
        }
        return null;
    }

    private MediapathDistributionSite findMediaPathDistributionSitebyName(String siteName) {
        ISiteManager siteManager = this.getSiteManager();
        Site mds = siteManager.getSiteByName(siteName);
        if (mds == null) {
            return null;
        }
        if (mds.getType() == SiteType.DISTRIBUTION && mds instanceof MediapathDistributionSite) {
            return (MediapathDistributionSite)mds;
        }
        return null;
    }

    private ISiteManager getSiteManager() {
        ISiteManager siteManager;
        try {
            siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Exception while finding SiteManager: ", e);
        }
        return siteManager;
    }

    private IScheduler getScheduler() {
        IScheduler scheduler;
        try {
            scheduler = (IScheduler)new InitialContext().lookup("cms/Scheduler/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Exception while finding Scheduler: ", e);
        }
        return scheduler;
    }

    private IRuleManager getRuleManager() {
        IRuleManager ruleManager;
        try {
            ruleManager = (IRuleManager)new InitialContext().lookup("cms/RuleManagerImpl/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Exception while finding RuleManager: ", e);
        }
        return ruleManager;
    }

    private static final /* synthetic */ void execute_aroundBody0(SyncronizeSites this_, ExecutionContext context) {
        this_.catcherGroupId = (String)context.getVariable(CATCHER_GROUP_ID);
        this_.catcherGroupName = (String)context.getVariable(CATCHER_GROUP_NAME);
        this_.catcherIds = (List)context.getVariable(CATCHER_IDS);
        this_.catcherNames = (List)context.getVariable(CATCHER_NAMES);
        ISiteManager siteManager = this_.getSiteManager();
        if (this_.catcherGroupId == null || this_.catcherGroupId.isEmpty()) {
            MediapathDistributionSite mds = this_.findMediaPathDistributionSitebyName(this_.catcherGroupName);
            if (mds != null) {
                this_.inactivateMediapathDistributionSite(mds);
                logger.info((Object)("Catcher group has been deleted in NGMP, so inactivated just the mediapath distribution site in CMS: " + this_.catcherGroupName));
            } else {
                logger.info((Object)("There is no mediapath distribution site with name: " + this_.catcherGroupName));
            }
        } else {
            MediapathDistributionSite mds = this_.findMediaPathDistributionSite(this_.catcherGroupId);
            if (mds == null) {
                this_.createMediaPathSite(this_.catcherGroupName, this_.catcherGroupId, this_.catcherIds);
                logger.info((Object)("Create a new mediapath distribution site with ts underneath it: " + this_.catcherGroupName));
            } else {
                mds = this_.syncMediaPathSite(mds, this_.catcherIds);
                siteManager.save((Site)mds);
            }
        }
    }

    private static final /* synthetic */ Object execute_aroundBody1$advice(SyncronizeSites this_, ExecutionContext context, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            SyncronizeSites.execute_aroundBody0(this_, context);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SyncronizeSites.execute_aroundBody0(this_, context);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

