<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
 	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	version="1.0"
	exclude-result-prefixes="tns fn xs" >

	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/package">
		<xsl:element name="ECMFSpec">
			<xsl:attribute name="xsi:noNamespaceSchemaLocation" namespace="http://www.w3.org/2001/XMLSchema-instance">ECMFSpec.xsd</xsl:attribute>
			<xsl:attribute name="revision">0</xsl:attribute>
			<xsl:element name="Package">
				<xsl:attribute name="assetId">-1</xsl:attribute>
				<xsl:element name="Title">
					<xsl:attribute name="assetId">-1</xsl:attribute>
					<xsl:element name="Fields">
						<xsl:choose>
							<xsl:when test="video">
								<xsl:apply-templates select="video" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="type" />
								<xsl:apply-templates select="series_name" />
								<xsl:apply-templates select="runtime" />

								<xsl:element name="ISAN">
									<xsl:value-of select="isan"/>
								</xsl:element>
								
								<xsl:element name="Title">
									<xsl:element name="DisplayTitle">
										<xsl:element name="Value">
											<xsl:value-of select="episode_name"/>
										</xsl:element>
									</xsl:element>
								</xsl:element>

								<xsl:element name="TvId">
									<xsl:element name="Network">
										<xsl:value-of select="network"/>
									</xsl:element>
									<xsl:element name="EpisodeSeasonNumber">
										<xsl:value-of select="season_number"/>
									</xsl:element>
								</xsl:element>
								
								<xsl:element name="Episode">
									<xsl:element name="Name">
										<xsl:element name="Value">
											<xsl:value-of select="episode_pn"/>
										</xsl:element>
									</xsl:element>
									<xsl:element name="Identifier">
										<xsl:element name="Id">
											<xsl:value-of select="air_order"/>
										</xsl:element>
									</xsl:element>
								</xsl:element>

								<xsl:element name="Copyright">
									<xsl:element name="Value">
										<xsl:value-of select="copyright"/>
									</xsl:element>
								</xsl:element>

								<xsl:element name="Summary">
									<xsl:element name="ShortSummary">
										<xsl:element name="Value">
											<xsl:value-of select="short_synopsis"/>
										</xsl:element>
									</xsl:element>
								</xsl:element>

								<xsl:element name="CreationInfo">
									<xsl:element name="PublicationDate">
										<xsl:value-of select="substring(release_date, 1, 4)"/>
									</xsl:element>
								</xsl:element>

								<xsl:element name="Genres">
									<xsl:for-each select="genre">
										<xsl:element name="Genre">
											<xsl:element name="Value">
												<xsl:value-of select="."/>
											</xsl:element>
										</xsl:element>
									</xsl:for-each>
								</xsl:element>
								
								<xsl:element name="CustomFields">
									<xsl:apply-templates select="series_synopsis" />
									<xsl:apply-templates select="season_id" />
									<xsl:apply-templates select="season_synopsis" />
									<xsl:apply-templates select="episode_id" />
									<xsl:apply-templates select="release_date" />
									<xsl:apply-templates select="audio_lang" />
									<xsl:apply-templates select="sales" />
								</xsl:element>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>

				<xsl:element name="Movie">
					<xsl:attribute name="assetId">-1</xsl:attribute>
					<xsl:element name="Fields">
						<xsl:element name="ProviderInfo">
							<xsl:element name="Identifier">
								<xsl:element name="Id">
									<xsl:value-of select="/package/provider"/>
								</xsl:element>
							</xsl:element>
							<xsl:element name="Name">
								<xsl:value-of select="/package/provider"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:element name="Preview">
					<xsl:attribute name="assetId">-1</xsl:attribute>
					<xsl:element name="Fields">
						<xsl:element name="ProviderInfo">
							<xsl:element name="Identifier">
								<xsl:element name="Id">
									<xsl:value-of select="/package/provider"/>
								</xsl:element>
							</xsl:element>
							<xsl:element name="Name">
								<xsl:value-of select="/package/provider"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:element name="Poster">
					<xsl:attribute name="assetId">-1</xsl:attribute>
					<xsl:element name="Fields">
						<xsl:element name="ProviderInfo">
							<xsl:element name="Identifier">
								<xsl:element name="Id">
									<xsl:value-of select="/package/provider"/>
								</xsl:element>
							</xsl:element>
							<xsl:element name="Name">
								<xsl:value-of select="/package/provider"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:element name="Fields">
					<xsl:apply-templates select="provider" />
					<xsl:apply-templates select="video/vendor_id" />
					<xsl:apply-templates select="vendor_id" />
					<xsl:apply-templates select="series_id" />
					
					<xsl:element name="CustomFields">
						<xsl:element name="CustomField">
							<xsl:attribute name="name">SpecVersion</xsl:attribute>
							<xsl:element name="Value">
								<xsl:value-of select="@version"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>

				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>

	<!-- provider -->
	<xsl:template match="provider">

		<xsl:element name="ProviderInfo">
			<xsl:element name="Identifier">
				<xsl:element name="Id">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="Name">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- video -->
	<xsl:template match="video">

		<xsl:apply-templates select="type" />
		<xsl:apply-templates select="runtime" />
		
		<xsl:element name="ISAN">
			<xsl:value-of select="isan"/>
		</xsl:element>
		<xsl:element name="Title">
			<xsl:element name="DisplayTitle">
				<xsl:element name="Value">
					<xsl:value-of select="title"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Description">
			<xsl:element name="Text">
				<xsl:value-of select="title"/>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Summary">
			<xsl:element name="ShortSummary">
				<xsl:element name="Value">
					<xsl:value-of select="synopsis"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="CreationInfo">
			<xsl:element name="PublicationDate">
				<xsl:value-of select="substring(theatrical_release_date, 1, 4)"/>
			</xsl:element>
			<xsl:element name="Place">
				<xsl:element name="Country">
					<xsl:value-of select="country_of_origin"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="Studio">
				<xsl:element name="Name">
					<xsl:value-of select="production_company"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Copyright">
			<xsl:element name="Value">
				<xsl:value-of select="copyright_cline"/>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Caption">
			<xsl:element name="Value">
				<xsl:choose>
					<xsl:when test="subtitle = 'True'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Genres">
			<xsl:for-each select="genres/genre">
				<xsl:element name="Genre">
					<xsl:element name="Value">
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
		<xsl:element name="Rating">
			<xsl:element name="RatingValues">
				<xsl:for-each select="ratings/rating">
					<xsl:element name="RatingValue">
						<xsl:element name="System">
							<xsl:value-of select="@system"/>
						</xsl:element>
						<xsl:element name="Value">
							<xsl:value-of select="."/>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Sources">
			<xsl:for-each select="artist/member">
				<xsl:element name="Source">
					<xsl:element name="Role">
						<xsl:element name="Name">
							<xsl:value-of select="upper-case(.)"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="Contact">
						<xsl:element name="DisplayName">
							<xsl:value-of select="@name"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
		<xsl:element name="CustomFields">
			<xsl:element name="CustomField">
				<xsl:attribute name="name">ReleaseDate</xsl:attribute>
				<xsl:element name="Value">
					<xsl:value-of select="theatrical_release_date"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="CustomField">
				<xsl:attribute name="name">Color</xsl:attribute>
				<xsl:element name="Value">
				<xsl:choose>
					<xsl:when test="color = 'True'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name="CustomField">
				<xsl:attribute name="name">Language</xsl:attribute>
				<xsl:element name="Value">
					<xsl:value-of select="language"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="CustomField">
				<xsl:attribute name="name">LanguageType</xsl:attribute>
				<xsl:element name="Value">
					<xsl:value-of select="language_type"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	<!-- type -->
	<xsl:template match="type">
		<xsl:element name="ShowType">
			<xsl:value-of select="."/>
		</xsl:element>

	</xsl:template>

	<!-- video/vendor_id -->
	<xsl:template match="video/vendor_id">

		<xsl:element name="Identifier">
			<xsl:element name="Id">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- vendor_id -->
	<xsl:template match="vendor_id">

		<xsl:element name="Identifier">
			<xsl:element name="Id">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- runtime -->
	<xsl:template match="runtime">
		
		<xsl:element name="Duration">
			<xsl:element name="Duration">
				<xsl:variable name="hours" select=". idiv 60"/>
				<xsl:variable name="minutes" select=". mod 60"/>
				<xsl:value-of select="$hours"/>
				<xsl:text>:</xsl:text>
				<xsl:value-of select="$minutes"/>
				<xsl:text>:00</xsl:text>
			</xsl:element>
			<xsl:element name="DisplayDuration">
				<xsl:variable name="hours" select=". idiv 60"/>
				<xsl:variable name="minutes" select=". mod 60"/>
				<xsl:value-of select="$hours"/>
				<xsl:text>:</xsl:text>
				<xsl:value-of select="$minutes"/>
			</xsl:element>
		</xsl:element>
	
	</xsl:template>
	
	<!-- network -->
	<xsl:template match="network">

		<xsl:element name="TvId">
			<xsl:element name="Network">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- series_name -->
	<xsl:template match="series_name">

		<xsl:element name="Description">
			<xsl:element name="Text">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- series_id -->
	<xsl:template match="series_id">

		<xsl:element name="Description">
			<xsl:element name="Text">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- series_synopsis -->
	<xsl:template match="series_synopsis">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">SeriesSynopsis</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- season_id -->
	<xsl:template match="season_id">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">SeasonId</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- season_synopsis -->
	<xsl:template match="season_synopsis">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">SeasonSynopsis</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- episode_id -->
	<xsl:template match="episode_id">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">EpisodeId</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	<!-- release_date -->
	<xsl:template match="release_date">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">ReleaseDate</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- audio_lang -->
	<xsl:template match="audio_lang">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">AudioLanguage</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<!-- sales -->
	<xsl:template match="sales">

		<xsl:element name="CustomField">
			<xsl:attribute name="name">Sales</xsl:attribute>
			<xsl:element name="Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>

	</xsl:template>
	
</xsl:stylesheet>