#!/bin/bash

BASHRC="/etc/bashrc"

if [[ -z `cat $BASHRC | grep "unset MAILCHECK"` ]] ; then
echo ""                                                                          >> $BASHRC
echo "# Disable options:"                                                        >> $BASHRC
echo "shopt -u mailwarn"                                                         >> $BASHRC
echo "unset MAILCHECK       # I don't want my shell to warn me of incoming mail" >> $BASHRC
echo ""                                                                          >> $BASHRC
fi 

if [[ -z `cat $BASHRC | grep "HISTTIMEFORMAT"` ]] ; then
echo "# Format History to Include Timestamp"                                     >> $BASHRC
echo "HISTTIMEFORMAT='%F %T  '"                                                  >> $BASHRC
echo ""
fi