#!/bin/bash
# Configures Memory for Application Server. 

#Memory Profiles in MB's
#            2GB       4GB       8GB       16GB       24GB       32GB       48GB       64GB       96GB       108GB*
#ARRAY#     [0]        [1]       [2]        [3]        [4]        [5]        [6]        [7]        [8]        [9] 
MEMTOTAL=(  '2048'    '4096'    '8192'    '16384'    '24576'    '32768'    '49152'    '65536'    '98304'    '110592' )
CMS=(       '1024'    '2048'    '4096'     '8192'    '16384'    '24576'    '32768'    '49152'    '65536'     '65536' )
TOMCAT=(     '256'     '512'    '2048'     '4096'     '4096'     '4096'     '8192'     '8192'    '16384'     '24576' )
XPORT=(      '256'     '512'    '1024'     '2048'     '2048'     '2048'     '4096'     '4096'     '8192'      '8192' )
RMSERVER=(   '256'     '512'     '512'     '1024'     '1024'     '1024'     '2048'     '2048'     '4096'      '4096' )
RESERVE=(    '256'     '512'     '512'     '1024'     '1024'     '1024'     '2048'     '2048'     '4096'      '8192' )
# RESERVE is slack space for the OS

i=0
SYS_MEMTOTAL_KB=`grep -ie 'MemTotal' /proc/meminfo | cut -d' ' -f2- | tr -d "[A-Z][a-z] "` # Get the total system memory
SYS_MEMTOTAL_MB=$(( $SYS_MEMTOTAL_KB / 1024 ))                                             # Convert the memory form KB to MB
while (( $SYS_MEMTOTAL_MB > $(( ${MEMTOTAL[$i]} - ${RESERVE[$i]} )) )) &> /dev/null        # While System Memory is less then Array 
    do
    i=$(( $i + 1 )) # 
done
i=$(( $i - 1 ))     # Go back to the previous array step for correct settings

if [[ $i = -1 ]]
then 
    echo "Not Enough Memory"
else
    echo "  Assigning $(( ${CMS[$i]})) MB to CMS process"
    sed -i "s/-Xmx[0-9]*[mMgG]/-Xmx$(( ${CMS[$i]}))m/g" /etc/init.d/cms
    echo "  Assigning $(( ${TOMCAT[$i]})) MB to TOMCAT process"
    sed -i "s/-Xmx[0-9]*[mMgG]/-Xmx$(( ${TOMCAT[$i]}))m/g" /etc/init.d/tomcat
    echo "  Assigning $(( ${XPORT[$i]})) MB to XPORT process"
    sed -i "s/-Xmx[0-9]*[mMgG]/-Xmx$(( ${XPORT[$i]}))m/g" /etc/init.d/xporttomcat
    echo "  Assigning $(( ${RMSERVER[$i]})) MB to RMSERVER process"
    sed -i "s/rmserver.cfg -m [0-9]*/rmserver.cfg -m $(( ${RMSERVER[$i]} ))/g" /etc/init.d/rmserver
    echo "Please restart services for changes to take affect"
fi
