#!/bin/bash

echo "Restarting Network Services"
service network restart

# Define some variables
APPNAME=`conary q | grep appliance | grep group | cut -d - -f 2`
IPADDR=`/sbin/ifconfig eth0 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'`
FIRSTOCT=`echo $IPADDR| awk '{split($0,OCT,".")} END{print OCT[1]}'`
SECONDOCT=`echo $IPADDR| awk '{split($0,OCT,".")} END{print OCT[2]}'`
THIRDOCT=`echo $IPADDR| awk '{split($0,OCT,".")} END{print OCT[3]}'`
FOURTHOCT=`echo $IPADDR| awk '{split($0,OCT,".")} END{print OCT[4]}'`
NEWHOSTNAME="$APPNAME-$THIRDOCT-$FOURTHOCT.workgroup"


# Change Hostname
echo "Changing Hostname to $NEWHOSTNAME"
sed -i "s/.*\(HOSTNAME=\).*/HOSTNAME=$NEWHOSTNAME/" /etc/sysconfig/network

# Add hostname to hosts file
echo "Adding Hostname and IP to hosts file"
echo "$IPADDR   $NEWHOSTNAME" >> /etc/hosts

# Restart network service to take effect
echo "Restarting Network Services"
service network restart

# Show what the systems sees now
echo "System Hostname is now "`hostname`
echo "IP is "`/sbin/ifconfig eth0 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'`
