#!/bin/bash
IPADDR=$1
FSTAB=/etc/fstab
MTAB=/etc/mtab
EXPORTDIR=/cmsappmq
MQDIR=/opt/tandbergtv/cms/workflow/mq
MOUNTOPTS=rw,soft,intr,timeo=10

EXISTS=$(grep $MQDIR $FSTAB | grep -v ^# | wc -l)
if [ $EXISTS == 0 ] ; then
    echo "$IPADDR:$EXPORTDIR $MQDIR nfs $MOUNTOPTS 0 0" >> $FSTAB
fi

mount $MQDIR

MOUNTED=$(grep $MQDIR $MTAB | wc -l)

if [ $MOUNTED == 0 ]; then
#For whatever reason, mount fails the first time - consistently - even if everything is OK.
#Works the second time. We can't retry forever, so if NFS server isn't ready, you have to run mount manually.
#Stop crying already.
    mount $MQDIR
fi
