#!/bin/bash
NETSCRIPTS="/etc/sysconfig/network-scripts/"

for ETH in `ls -1 $NETSCRIPTS | grep ifcfg-eth`
do
echo "Updating Deafult Network Values for $ETH"
sed -i 's/BOOTPROTO="dhcp"/BOOTPROTO="none"/g'  $NETSCRIPTS/$ETH
sed -i 's/ONBOOT="no"/ONBOOT="yes"/g'           $NETSCRIPTS/$ETH
echo USERCNTL=\"no\" >>                         $NETSCRIPTS/$ETH
if [[ -n `cat $NETSCRIPTS/$ETH | grep IPV6INIT` ]]; then
    sed -i 's/IPV6INIT="yes"/IPV6INIT="no"/g'   $NETSCRIPTS/$ETH
else 
    echo IPV6INIT=\"no\" >>                     $NETSCRIPTS/$ETH
fi
done
echo "Restarting Network Services"
`service network restart`