#!/bin/bash

#Systems Service to be disbled at boot
chkconfig --del iptables
chkconfig --del smb

#System Service to be enabled at boot
chkconfig --add ntpd
chkconfig ntpd on
chkconfig --add snmpd
chkconfig snmpd on
chkconfig --add snmptrapd
chkconfig snmptrapd on

#Service to be enabled on the Appliance Only
if [[ -n `conary q | grep group-cmsapp-appliance` ]]; then
    chkconfig --add nfs 
    chkconfig nfs on

    #IF VCS is running and licensed
    if [[ -n `/etc/init.d/vcs status | grep running...` ]] && [[ -n `ls /etc/vx/licenses/lic/ | grep ".vxlic"` ]] ; then
        #CMS service to be disabled at boot
        chkconfig --del tomcat
        chkconfig --del alerts
        chkconfig --del cms
        chkconfig --del RCSSchedulerService
        chkconfig --del xporttomcat
        chkconfig --del xportmanager

        #VCS Service to be enabled at boot
        chkconfig --add amf
        chkconfig --add gab
        chkconfig --add llt
        chkconfig --add vcs
        chkconfig --add vxatd
        chkconfig --add vxfen
    else
        #CMS Service to be enabled at boot
        chkconfig --add tomcat
        chkconfig --add alerts
        chkconfig --add cms
        chkconfig --add RCSSchedulerService
        chkconfig --add xporttomcat
        chkconfig --add xportmanager

        #VCS Service to be disabled at boot
        chkconfig --del amf
        chkconfig --del gab
        chkconfig --del llt
        chkconfig --del vcs
        chkconfig --del vxatd
        chkconfig --del vxfen
    fi
fi

#Services to be run on the Appliance or Database but not RAC
if [[ -n `conary q | grep group-cmsapp-appliance` ]] || [[ -n `conary q | grep group-cmsdb-appliance` ]]  ; then
    chkconfig --add ntpdate
    chkconfig ntpdate on
fi

#Service to be Enabled on Database and RAC but not Appliance
if [[ -n `conary q | grep group-cmsdb-appliance` ]] || [[ -n `conary q | grep group-cmsrac-appliance` ]] ; then
    echo ""
fi

#Services to enabled on RAC only
if [[ -n `conary q | grep group-cmsrac-appliance` ]] ; then
    chkconfig --add multipathd
    chkconfig multipathd on
fi
