#!/bin/bash

TIMESTAMP=`date -u "+%Y%m%d_%H%M"`
CONSOLEOUT="%-55s"
VAR="/usr/sbin/sysprep/sedtest/"
SEARCHSTRING="[a-zA-Z0-9.-]*"

# Set the Defaults for the cluster
if [[ $1 == "--HA" ]]; then 
    default_dbservername() {
        DBSERVERNAME="dbcluster-scan"
    }
else
    default_dbservername() {
        DBSERVERNAME="dbserver"
    }
fi 

default_dbinstance() {
    DBINSTANCE="ttv"
}

if [[ -n $2 ]] && [[ -n $3 ]] ; then 
    DBSERVERNAME=$2
    DBINSTANCE=$3
else 
    #Set Defaultsbash 
    default_dbservername
    default_dbinstance
    
    while [[ $CORRECT != "y" ]]
    do
        printf "$CONSOLEOUT" "Enter Database Servername/Host Alias [$DBSERVERNAME]"
        read DBSERVERNAME
        if [[ -z $DBSERVERNAME ]] ; then 
            default_dbservername
        fi

        printf "$CONSOLEOUT" "Enter Database Instance Name [$DBINSTANCE]"
        read DBINSTANCE
        if [[ -z $DBINSTANCE ]] ; then 
            default_dbinstance
        fi
        
        printf "$CONSOLEOUT" "Is this correct? [y/n]"
        read CORRECT
    done
fi 

sed -i "s|dbserver=$SEARCHSTRING|dbserver=$DBSERVERNAME|gI"                                                                       '/opt/tandbergtv/cms/conf/epgmgmt/config.properties'
sed -i "s|EPG_FTP_HOST=$SEARCHSTRING|EPG_FTP_HOST=$DBSERVERNAME|gI"                                                               '/opt/tandbergtv/cms/conf/rcs/properties/Config.properties'
sed -i "s|RcsSystem.ConnectionPool.serverName=$SEARCHSTRING|RcsSystem.ConnectionPool.serverName=$DBSERVERNAME|gI"                 '/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties'
sed -i "s|RcsSystem.ConnectionPool.dbName=$SEARCHSTRING|RcsSystem.ConnectionPool.dbName=$DBINSTANCE|gI"                         '/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties'
sed -i "s|RecReqQueueSystem.ConnectionPool.serverName=$SEARCHSTRING|RecReqQueueSystem.ConnectionPool.serverName=$DBSERVERNAME|gI" '/usr/local/tstv/RCSScheduler/config/RecReqQueueSystem.properties'
sed -i "s|RecReqQueueSystem.ConnectionPool.dbName=$SEARCHSTRING|RecReqQueueSystem.ConnectionPool.dbName=$DBINSTANCE|gI"         '/usr/local/tstv/RCSScheduler/config/RecReqQueueSystem.properties'
sed -i "s|RcsSystem.ConnectionPool.serverName=$SEARCHSTRING|RcsSystem.ConnectionPool.serverName=$DBSERVERNAME|gI"                 '/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties'
sed -i "s|RcsSystem.ConnectionPool.dbName=$SEARCHSTRING|RcsSystem.ConnectionPool.dbName=$DBINSTANCE|gI"                         '/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties'

if [[ $1 == "--HA" ]]; then 
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521/$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/epgmanager-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521/$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/jms-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521/$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/neptune-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521/$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/oracle-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521/$DBINSTANCE|gI"         '/usr/local/n2bb/conf/alerts_settings.conf'
else 
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521:$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/epgmanager-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521:$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/jms-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521:$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/neptune-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521:$DBINSTANCE|gI"         '/opt/tandbergtv/cms/jboss/server/standard/deploy/oracle-ds.xml'
    sed -i "s|jdbc:oracle:thin:@$SEARCHSTRING:1521[:\/]$SEARCHSTRING|jdbc:oracle:thin:@$DBSERVERNAME:1521:$DBINSTANCE|gI"         '/usr/local/n2bb/conf/alerts_settings.conf'
fi
