/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.plugins.ta;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.IAutoFillVariableProvider;
import java.text.DecimalFormat;
import java.util.List;

public class AssetIdGenerator
implements IAutoFillVariableProvider {
    public String getValue(Title title, Asset asset) {
        return this.getPrefix(asset) + this.getNewId(this.getPosition(title, asset));
    }

    private int getPosition(Title title, Asset asset) {
        List allAssetsInTree = title.getAsset().getAllAssets(false);
        for (int i = 0; i < allAssetsInTree.size(); ++i) {
            if (!((Asset)allAssetsInTree.get(i)).equals(asset)) continue;
            return i;
        }
        return -1;
    }

    private String getPrefix(Asset asset) {
        String assetType = asset.getAssetType();
        if (assetType == null || assetType.length() < 2) {
            return "CMXX";
        }
        return "CM" + assetType.substring(0, 2);
    }

    private String getNewId(int assetPositionInTree) {
        long t = System.currentTimeMillis();
        String IDString = String.valueOf(assetPositionInTree) + t;
        t = Long.parseLong(IDString);
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(16);
        String pattern = "0000000000000000";
        df.applyPattern(pattern);
        return df.format(t);
    }
}

