/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.odgorf;

import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OdgOrfIdentifier
extends IdentifierBase {
    private static final long serialVersionUID = 1L;
    private static String EXTERNAL_TITLE_ID_XPATH = "ExternalTitleId";
    private String externalTitleId;

    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(EXTERNAL_TITLE_ID_XPATH, this.externalTitleId);
        return map;
    }

    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String externalIdXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)EXTERNAL_TITLE_ID_XPATH);
        if (externalIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + EXTERNAL_TITLE_ID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(EXTERNAL_TITLE_ID_XPATH, externalIdXpath);
        return ttvPaths;
    }

    public boolean isValidIdentifier() {
        return this.externalTitleId != null && !this.externalTitleId.equals("");
    }

    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(EXTERNAL_TITLE_ID_XPATH)) {
            this.setExternalId(identifiers.get(EXTERNAL_TITLE_ID_XPATH));
        } else {
            this.setExternalId(null);
        }
    }

    private void setExternalId(String billingId) {
        this.externalTitleId = billingId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalTitleId == null ? 0 : this.externalTitleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OdgOrfIdentifier other = (OdgOrfIdentifier)((Object)obj);
        return !(this.externalTitleId == null ? other.externalTitleId != null : !this.externalTitleId.equals(other.externalTitleId));
    }

    public String toString() {
        return this.externalTitleId;
    }

    public List<SearchField> addSearchFields(SearchCriteria criteriaMap) {
        return this.buildFields(criteriaMap);
    }

    protected List<SearchField> buildSearchFields(SearchCriteria criteriaMap) {
        return this.buildFields(criteriaMap);
    }

    private List<SearchField> buildFields(SearchCriteria criteriaMap) {
        List fields = new SearchFieldBuilder().getAssetSearchFields(criteriaMap, true, null, true, true);
        for (SearchField idField : fields) {
            if (!(idField instanceof MetadataValueFieldInfo)) continue;
            ((MetadataValueFieldInfo)idField).setAssetType(Item.ItemType.TITLE.toString());
            break;
        }
        return fields;
    }
}

