/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.odgorf;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.odgorf.OdgOrfIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class OdgOrfSpecHandler
extends SingleTitleSpecHandler {
    private static final String VIDEO_ROOTELEMENT_NAME_CLIPS = "importVideoWithClips";
    private static final String VIDEO_ROOTELEMENT_NAME = "importVideo";

    public OdgOrfSpecHandler() {
        this.alias = "OdgOrf";
    }

    public IIdentifier extractId(Asset asset) {
        OdgOrfIdentifier id = new OdgOrfIdentifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iter = idXPaths.entrySet().iterator();
        ArrayList<String> assetTypes = new ArrayList<String>();
        assetTypes.add("PACKAGE");
        assetTypes.add("TITLE");
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            List fields = asset.getAllFieldsForXpath(assetTypes, entry.getValue());
            if (fields.isEmpty() || fields.get(0) == null) continue;
            idValues.put(entry.getKey(), ((Field)fields.get(0)).getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        OdgOrfIdentifier identifier = new OdgOrfIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    public String getSpecAlias(Document doc) {
        String name = doc.getDocumentElement().getNodeName();
        if (name.equals(VIDEO_ROOTELEMENT_NAME_CLIPS) || name.equals(VIDEO_ROOTELEMENT_NAME)) {
            return this.alias;
        }
        return null;
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        return Item.ItemType.TITLE.toString().equalsIgnoreCase(assetType) || Group.GroupType.MOVIE.toString().equalsIgnoreCase(assetType) || Group.GroupType.PREVIEW.toString().equalsIgnoreCase(assetType) || Item.ItemType.POSTER.toString().equalsIgnoreCase(assetType) || Item.ItemType.ENCRYPTED.toString().equalsIgnoreCase(assetType);
    }

    protected void specSpecificMergingNoSave(Asset newAsset, Relation oldRelation, Asset existingAsset) {
        if (existingAsset.getType().equals(Item.ItemType.TITLE.toString())) {
            super.specSpecificMergingNoSave(newAsset, oldRelation, existingAsset);
        } else if (existingAsset.getType().equals(Group.GroupType.MOVIE.toString()) || existingAsset.getType().equals(Group.GroupType.PREVIEW.toString()) || existingAsset.getType().equals(Item.ItemType.POSTER.toString()) || existingAsset.getType().equals(Item.ItemType.ENCRYPTED.toString())) {
            newAsset.addChild(this.copyAssetTree(existingAsset));
        }
    }

    public List<SearchField> getSearchFieldsToValidatePersistedCopies(Asset asset) {
        List fields = super.getSearchFieldsToValidatePersistedCopies(asset);
        if (fields != null && !fields.isEmpty()) {
            for (SearchField f : fields) {
                if (!(f instanceof MetadataValueFieldInfo)) continue;
                ((MetadataValueFieldInfo)f).setAssetType(Item.ItemType.TITLE.toString());
            }
        }
        return fields;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("tns:CustomField")) {
            return true;
        }
        return supperResult;
    }
}

