/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.plugins.barker;

import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;

public class BarkerExporter
implements IAssetListExporter {
    public String export(AssetList assetList, String dirPath) throws AssetListExporterException {
        String filePath = this.generateFilePath(assetList.getId(), dirPath);
        FileWriter outFile = null;
        try {
            outFile = new FileWriter(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter out = new PrintWriter(outFile);
        out.println("Id : " + assetList.getId());
        out.println("Name : " + assetList.getName());
        out.println("Description : " + assetList.getDescription());
        out.println("Content Class : " + assetList.getContentClass());
        out.println("Assets : ");
        for (AssetListAssetMap assetMap : assetList.getAssetsMap()) {
            out.println(" Asset Id: " + assetMap.getAssetId());
            out.println(" Title Id: " + assetMap.getTitle().getId());
            out.println("");
        }
        out.close();
        return filePath;
    }

    private String generateFilePath(long id, String folderPath) {
        String EXPORT_FILENAME_PREFIX = "TitleList";
        String EXPORT_FILENAME_DELIMITER = "_";
        String EXPORT_FILENAME_EXTEN = ".txt";
        String fileName = EXPORT_FILENAME_PREFIX + EXPORT_FILENAME_DELIMITER + id + EXPORT_FILENAME_DELIMITER + Calendar.getInstance().getTimeInMillis() + EXPORT_FILENAME_EXTEN;
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }
}

